/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.lang.scala;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.TypeArg;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.IdentifierModel;
import io.vertx.codetrans.expression.JsonArrayLiteralModel;
import io.vertx.codetrans.expression.JsonObjectLiteralModel;
import io.vertx.codetrans.expression.JsonObjectModel;
import io.vertx.codetrans.expression.Member;
import io.vertx.codetrans.expression.NullLiteralModel;
import io.vertx.codetrans.statement.StatementModel;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.lang.model.element.TypeElement;

public class ScalaCodeWriter
extends CodeWriter {
    public ScalaCodeWriter(CodeBuilder builder) {
        super(builder);
    }

    private String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
    }

    @Override
    public void renderNewMap() {
        this.append("Map()");
    }

    @Override
    public void renderChars(String value) {
        this.renderChars(value, false);
    }

    private void renderChars(String value, boolean interpolated) {
        block10: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': {
                    this.append("\\b");
                    continue block10;
                }
                case '\f': {
                    this.append("\\f");
                    continue block10;
                }
                case '\n': {
                    this.append("\\n");
                    continue block10;
                }
                case '\t': {
                    this.append("\\t");
                    continue block10;
                }
                case '\r': {
                    this.append("\\r");
                    continue block10;
                }
                case '\"': {
                    this.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.append("\\\\");
                    continue block10;
                }
                case '$': {
                    if (interpolated) {
                        this.append('$');
                    }
                    this.append('$');
                    continue block10;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String s = Integer.toHexString(c).toUpperCase();
                        while (s.length() < 4) {
                            s = "0" + s;
                        }
                        this.append("\\u").append(s);
                        continue block10;
                    }
                    this.append(c);
                }
            }
        }
    }

    @Override
    public void renderStringLiteral(List<?> parts) {
        boolean interpolated = parts.stream().anyMatch(a -> a instanceof ExpressionModel);
        if (interpolated) {
            this.append("s\"");
        } else {
            this.append("\"");
        }
        parts.stream().forEach(part -> {
            if (part instanceof ExpressionModel) {
                this.append("${");
                ((ExpressionModel)part).render(this);
                this.append("}");
            } else {
                this.renderChars(part.toString(), interpolated);
            }
        });
        this.append("\"");
    }

    @Override
    public void renderNew(ExpressionModel expression, TypeInfo type, List<ExpressionModel> argumentModels) {
        if (ClassKind.API != type.getKind() && !type.isDataObjectHolder()) {
            this.append("new ");
        }
        expression.render(this);
        this.append('(');
        IntStream.range(0, argumentModels.size()).forEach(i -> {
            if (i > 0) {
                this.append(", ");
            }
            ((ExpressionModel)argumentModels.get(i)).render(this);
        });
        this.append(')');
    }

    @Override
    public void renderSystemOutPrintln(ExpressionModel expression) {
        this.append("println(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderSystemErrPrintln(ExpressionModel expression) {
        this.append("System.err.println(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderAsyncResultValue(TypeInfo resultType, String name) {
        this.append("todo-renderAsyncResultValue");
    }

    @Override
    public void renderAsyncResultSucceeded(TypeInfo resultType, String name) {
        this.append("todo-renderAsyncResultSucceeded");
    }

    @Override
    public void renderAsyncResultFailed(TypeInfo resultType, String name) {
        this.append("todo-renderAsyncResultFailed");
    }

    @Override
    public void renderAsyncResultCause(TypeInfo resultType, String name) {
        this.append("todo-renderAsyncResultCause");
    }

    @Override
    public void renderListGet(ExpressionModel list, ExpressionModel index) {
        list.render(this);
        this.append("(");
        index.render(this);
        this.append(")");
    }

    @Override
    public void renderMethodReference(ExpressionModel expressionModel, MethodSignature methodSignature) {
        expressionModel.render(this);
        this.append('.');
        this.append(methodSignature.getName()).append(" _");
    }

    @Override
    public void renderApiType(ApiTypeInfo apiType) {
        this.append(apiType.getSimpleName());
    }

    @Override
    public void renderListLiteral(List<ExpressionModel> arguments) {
        this.append("List(");
        IntStream.range(0, arguments.size()).forEach(i -> {
            if (i > 0) {
                this.append(", ");
            }
            ((ExpressionModel)arguments.get(i)).render(this);
        });
        this.append(')');
    }

    @Override
    public void renderNewArray(String primitiveType, List<ExpressionModel> arguments) {
        this.append("Array(");
        IntStream.range(0, arguments.size()).forEach(i -> {
            if (i > 0) {
                this.append(", ");
            }
            ((ExpressionModel)arguments.get(i)).render(this);
        });
        this.append(')');
    }

    @Override
    public void renderJsonObjectMemberSelect(ExpressionModel expression, Class<?> type, String name) {
        expression.render(this);
        this.append(".getValue(\"");
        this.append(name);
        this.append("\")");
    }

    @Override
    public void renderToDataObject(JsonObjectModel model, ClassTypeInfo type) {
        this.append("todo-renderToDataObject");
    }

    @Override
    public void renderDataObjectMemberSelect(ExpressionModel expression, String name) {
        this.append("todo-renderDataObjectMemberSelect");
    }

    @Override
    public void renderJsonObjectSize(ExpressionModel expression) {
        this.append("todo-renderJsonObjectSize");
    }

    @Override
    public void renderJsonArraySize(ExpressionModel expression) {
        this.append("todo-renderJsonArraySize");
    }

    @Override
    public void renderEnumConstant(EnumTypeInfo type, String constant) {
        this.append(type.getSimpleName()).append('.').append(constant);
    }

    @Override
    public void renderJsonObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        expression.render(this);
        this.append(".put(\"");
        this.append(name);
        this.append("\", ");
        if (value instanceof NullLiteralModel) {
            this.append("null.asInstanceOf[String]");
        } else {
            value.render(this);
        }
        this.append(")");
    }

    @Override
    public void renderListSize(ExpressionModel list) {
        list.render(this);
        this.append(".size");
    }

    @Override
    public void renderLambda(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body) {
        this.append("(");
        IntStream.range(0, parameterNames.size()).forEach(i -> {
            if (i > 0) {
                this.append(", ");
            }
            this.append((CharSequence)parameterNames.get(i));
            this.append(": ");
            this.append(((TypeInfo)parameterTypes.get(i)).translateName("scala"));
        });
        this.append(") => {\n");
        this.indent();
        body.render(this);
        if (bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            this.append("\n");
        }
        this.unindent();
        this.append("}");
    }

    @Override
    public void renderMapGet(ExpressionModel map, ExpressionModel key) {
        map.render(this);
        this.append('(');
        key.render(this);
        this.append(')');
    }

    @Override
    public void renderNewList() {
        this.append("List()");
    }

    @Override
    public void renderJavaType(ClassTypeInfo apiType) {
        this.append(apiType.getName());
    }

    @Override
    public void renderMapPut(ExpressionModel map, ExpressionModel key, ExpressionModel value) {
        map.render(this);
        this.append(" + (");
        key.render(this);
        this.append(" -> ");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderThrow(String throwableType, ExpressionModel reason) {
        if (reason == null) {
            this.append("throw new ").append(throwableType).append("()");
        } else {
            this.append("throw new ").append(throwableType).append("(");
            reason.render(this);
            this.append(")");
        }
    }

    @Override
    public void renderMapForEach(ExpressionModel map, String keyName, TypeInfo keyType, String valueName, TypeInfo valueType, LambdaExpressionTree.BodyKind bodyKind, CodeModel block) {
        map.render(this);
        this.append(".foreach{\n");
        this.indent();
        this.append("case ");
        this.unindent();
        this.renderLambda(bodyKind, Arrays.asList(keyType, valueType), Arrays.asList(keyName, valueName), block);
        this.append("}");
    }

    @Override
    public void renderJsonObject(JsonObjectLiteralModel jsonObject) {
        this.append("new io.vertx.core.json.JsonObject()");
        jsonObject.getMembers().forEach(m -> {
            this.append(".put(\"");
            this.append(m.getName());
            this.append("\", ");
            this.renderMembers((Member)m);
            this.append(")");
        });
    }

    private void renderMembers(Member m) {
        if (m instanceof Member.Single) {
            ((Member.Single)m).getValue().render(this);
        } else if (m instanceof Member.Sequence) {
            ((Member.Sequence)m).getValues().forEach(v -> v.render(this));
        } else if (m instanceof Member.Entries) {
            ((Member.Entries)m).entries().forEach(e -> this.renderMembers((Member)e));
        }
    }

    @Override
    public void renderTryCatch(StatementModel tryBlock, StatementModel catchBlock) {
        this.append("try {\n");
        this.indent();
        tryBlock.render(this);
        this.unindent();
        this.append("} catch {\n");
        this.indent();
        this.append("case e:Exception => ");
        catchBlock.render(this);
        this.unindent();
        this.append("}\n");
    }

    @Override
    public void renderJsonObjectToString(ExpressionModel expression) {
        expression.render(this);
        this.append(".encode()");
    }

    @Override
    public void renderJsonArrayAdd(ExpressionModel expression, ExpressionModel value) {
        expression.render(this);
        if (value instanceof NullLiteralModel) {
            this.append(".addNull()");
        } else {
            this.append(".add(");
            value.render(this);
            this.append(")");
        }
    }

    @Override
    public void renderJsonArrayToString(ExpressionModel expression) {
        expression.render(this);
        this.append(".encodePrettily()");
    }

    @Override
    public void renderJsonArrayGet(ExpressionModel expression, Class<?> type, ExpressionModel index) {
        expression.render(this);
        this.append(".getValue(");
        index.render(this);
        this.append(")");
    }

    @Override
    public void renderJsonArray(JsonArrayLiteralModel jsonArray) {
        this.append("new io.vertx.core.json.JsonArray()");
        jsonArray.getValues().forEach(v -> {
            this.append(".add(");
            v.render(this);
            this.append(")");
        });
    }

    @Override
    public void renderDataObject(DataObjectLiteralModel model) {
        this.append(model.getType().getSimpleName() + "()");
        boolean dataModelHasMembers = model.getMembers().iterator().hasNext();
        if (dataModelHasMembers) {
            this.append("\n");
            this.indent();
        }
        model.getMembers().forEach(member -> {
            this.append(".set" + this.capitalize(member.getName()) + "(");
            if (member instanceof Member.Single) {
                ((Member.Single)member).getValue().render(this);
            } else if (member instanceof Member.Sequence) {
                this.append("Set(");
                IntStream.range(0, ((Member.Sequence)member).getValues().size()).forEach(i -> {
                    if (i > 0) {
                        this.append(", ");
                    }
                    ((Member.Sequence)member).getValues().get(i).render(this);
                });
                this.append(")");
            } else if (member instanceof Member.Entries) {
                this.append("todo-renderDataObject-entries");
            }
            this.append(")\n");
        });
        if (dataModelHasMembers) {
            this.unindent();
        }
    }

    @Override
    public void renderDataObjectToJson(IdentifierModel model) {
        model.render(this);
        this.append(".toJson()");
    }

    @Override
    public void renderListAdd(ExpressionModel list, ExpressionModel value) {
        list.render(this);
        this.append(" :::= List(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderStatement(StatementModel statement) {
        statement.render(this);
        this.append("\n");
    }

    @Override
    public void renderThis() {
        this.append("this");
    }

    @Override
    public void renderDataObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        expression.render(this);
        this.append(".set" + this.capitalize(name) + "(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderInstanceOf(ExpressionModel expression, TypeElement type) {
        expression.render(this);
        this.append(".isInstanceOf[");
        this.append(type.getQualifiedName());
        this.append("]");
    }

    @Override
    public void renderPrefixDecrement(ExpressionModel expression) {
        this.renderPostfixDecrement(expression);
    }

    @Override
    public void renderPrefixIncrement(ExpressionModel expression, CodeWriter writer) {
        this.renderPostfixIncrement(expression);
    }

    @Override
    public void renderPostfixIncrement(ExpressionModel expression) {
        expression.render(this);
        this.append(" += 1");
    }

    @Override
    public void renderPostfixDecrement(ExpressionModel expression) {
        expression.render(this);
        this.append(" -= 1");
    }

    @Override
    public void renderMethodInvocation(ExpressionModel expression, TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<TypeArg> typeArguments, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        String rbracket;
        String lbracket = method.getName() == "onComplete" ? "" : "(";
        String string = rbracket = method.getName() == "onComplete" ? "" : ")";
        if (method.getName() != "onComplete") {
            expression.render(this);
        }
        this.append('.');
        this.append(method.getName());
        this.append(lbracket);
        IntStream.range(0, argumentModels.size()).forEach(i -> {
            if (i > 0) {
                this.append(", ");
            }
            ((ExpressionModel)argumentModels.get(i)).render(this);
        });
        this.append(rbracket);
    }
}

