/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.consul;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;

public class ConsulConfigStore
implements ConfigStore {
    private final ConsulClient client;
    private final String delimiter;
    private final String prefix;

    ConsulConfigStore(Vertx vertx, JsonObject configuration) {
        this.client = ConsulClient.create((Vertx)vertx, (ConsulClientOptions)new ConsulClientOptions(configuration));
        this.delimiter = configuration.getString("delimiter", "/");
        this.prefix = ConsulConfigStore.prefix(configuration.getString("prefix"), this.delimiter);
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.client.getValues(this.prefix, kv -> {
            if (kv.succeeded()) {
                KeyValueList list = (KeyValueList)kv.result();
                if (list.isPresent()) {
                    JsonObject tree = ConsulConfigStore.getTree(list, this.prefix.length(), this.delimiter);
                    completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)tree.toString())));
                } else {
                    completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)"{}")));
                }
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)kv.cause()));
            }
        });
    }

    public void close(Handler<Void> completionHandler) {
        this.client.close();
        completionHandler.handle(null);
    }

    private static JsonObject getTree(KeyValueList list, int prefix, String delimiter) {
        JsonObject tree = new JsonObject();
        for (KeyValue keyValue : list.getList()) {
            if (keyValue.getKey().endsWith(delimiter)) continue;
            JsonObject json = tree;
            String[] arr = keyValue.getKey().substring(prefix).split(delimiter);
            for (int i = 0; i < arr.length; ++i) {
                String key = arr[i];
                if (i == arr.length - 1) {
                    json.put(key, keyValue.getValue());
                    continue;
                }
                JsonObject next = json.getJsonObject(key);
                if (next == null) {
                    next = new JsonObject();
                    json.put(key, next);
                }
                json = next;
            }
        }
        return tree;
    }

    private static String prefix(String prefix, String delimiter) {
        if (prefix == null || prefix.isEmpty()) {
            return "";
        }
        return prefix.endsWith(delimiter) ? prefix : prefix + delimiter;
    }
}

