/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.FileSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class GitConfigStore
implements ConfigStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitConfigStore.class);
    private final Vertx vertx;
    private final File path;
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final String url;
    private final String branch;
    private final String remote;
    private final Git git;
    private final CredentialsProvider credentialProvider;
    private final TransportConfigCallback transportConfigCallback;

    public GitConfigStore(Vertx vertx, final JsonObject configuration) {
        this.vertx = vertx;
        String path = Objects.requireNonNull(configuration.getString("path"), "The `path` configuration is required.");
        this.path = new File(path);
        if (this.path.isFile()) {
            throw new IllegalArgumentException("The `path` must not be a file");
        }
        JsonArray filesets = Objects.requireNonNull(configuration.getJsonArray("filesets"), "The `filesets` element is required.");
        for (Object o : filesets) {
            JsonObject json = (JsonObject)o;
            FileSet set = new FileSet(vertx, this.path, json);
            this.filesets.add(set);
        }
        this.url = Objects.requireNonNull(configuration.getString("url"), "The `url` configuration (Git repository location) is required.");
        this.branch = configuration.getString("branch", "master");
        this.remote = configuration.getString("remote", "origin");
        this.credentialProvider = Objects.nonNull(configuration.getString("user")) && Objects.nonNull(configuration.getString("password")) ? new UsernamePasswordCredentialsProvider(configuration.getString("user"), configuration.getString("password")) : null;
        if (Objects.nonNull(configuration.getString("idRsaKeyPath"))) {
            JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host host, Session session) {
                }

                protected JSch createDefaultJSch(FS fs) throws JSchException {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
                    defaultJSch.addIdentity(configuration.getString("idRsaKeyPath"));
                    return defaultJSch;
                }
            };
            this.transportConfigCallback = new TransportConfigCallback((SshSessionFactory)sshSessionFactory){
                final /* synthetic */ SshSessionFactory val$sshSessionFactory;
                {
                    this.val$sshSessionFactory = sshSessionFactory;
                }

                public void configure(Transport transport) {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory(this.val$sshSessionFactory);
                }
            };
        } else {
            this.transportConfigCallback = null;
        }
        try {
            this.git = this.initializeGit();
        }
        catch (Exception e) {
            throw new VertxException("Unable to initialize the Git repository", (Throwable)e);
        }
    }

    private Git initializeGit() throws IOException, GitAPIException {
        if (this.path.isDirectory()) {
            Git git = Git.open((File)this.path);
            String current = git.getRepository().getBranch();
            if (this.branch.equalsIgnoreCase(current)) {
                PullResult pull = ((PullCommand)((PullCommand)git.pull().setRemote(this.remote).setCredentialsProvider(this.credentialProvider)).setTransportConfigCallback(this.transportConfigCallback)).call();
                if (!pull.isSuccessful()) {
                    LOGGER.warn((Object)("Unable to pull the branch + '" + this.branch + "' from the remote repository '" + this.remote + "'"));
                }
                return git;
            }
            git.checkout().setName(this.branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(this.remote + "/" + this.branch).call();
            return git;
        }
        return ((CloneCommand)((CloneCommand)Git.cloneRepository().setURI(this.url).setBranch(this.branch).setRemote(this.remote).setDirectory(this.path).setCredentialsProvider(this.credentialProvider)).setTransportConfigCallback(this.transportConfigCallback)).call();
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.update().compose(v -> this.read()).compose(this::compute).setHandler(completionHandler);
    }

    private Future<Buffer> compute(List<File> files) {
        Promise result = Promise.promise();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (FileSet set : this.filesets) {
            Promise future = Promise.promise();
            set.buildConfiguration(files, json -> {
                if (json.failed()) {
                    future.fail(json.cause());
                } else {
                    future.complete(json.result());
                }
            });
            futures.add(future.future());
        }
        CompositeFuture.all(futures).setHandler(cf -> {
            if (cf.failed()) {
                result.fail(cf.cause());
            } else {
                JsonObject json = new JsonObject();
                futures.stream().map(f -> (JsonObject)f.result()).forEach(arg_0 -> ((JsonObject)json).mergeIn(arg_0));
                result.complete((Object)Buffer.buffer((String)json.encode()));
            }
        });
        return result.future();
    }

    private Future<Void> update() {
        Promise result = Promise.promise();
        this.vertx.executeBlocking(future -> {
            PullResult call;
            try {
                call = ((PullCommand)this.git.pull().setRemote(this.remote).setRemoteBranchName(this.branch).setCredentialsProvider(this.credentialProvider)).call();
            }
            catch (GitAPIException e) {
                future.fail((Throwable)e);
                return;
            }
            if (call.isSuccessful()) {
                future.complete();
            } else if (call.getMergeResult() != null) {
                future.fail("Unable to merge repository - Conflicts: " + call.getMergeResult().getCheckoutConflicts());
            } else {
                future.fail("Unable to rebase repository - Conflicts: " + call.getRebaseResult().getConflicts());
            }
        }, (Handler)result);
        return result.future();
    }

    private Future<List<File>> read() {
        Promise result = Promise.promise();
        this.vertx.executeBlocking(fut -> {
            try {
                fut.complete(FileSet.traverse((File)this.path).stream().sorted().collect(Collectors.toList()));
            }
            catch (Throwable e) {
                fut.fail(e);
            }
        }, (Handler)result);
        return result.future();
    }

    public void close(Handler<Void> completionHandler) {
        this.vertx.runOnContext(v -> {
            if (this.git != null) {
                this.git.close();
            }
            completionHandler.handle(null);
        });
    }
}

