/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import io.vertx.config.spi.ConfigProcessor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;

public class HoconProcessor
implements ConfigProcessor {
    public String name() {
        return "hocon";
    }

    public void process(Vertx vertx, JsonObject configuration, Buffer input, Handler<AsyncResult<JsonObject>> handler) {
        vertx.executeBlocking(future -> {
            try (StringReader reader = new StringReader(input.toString("UTF-8"));){
                Config conf = ConfigFactory.parseReader((Reader)reader);
                conf = conf.resolve();
                String output = conf.root().render(ConfigRenderOptions.concise().setJson(true).setComments(false).setFormatted(false));
                JsonObject json = new JsonObject(output);
                future.complete((Object)json);
            }
            catch (Exception e) {
                future.fail((Throwable)e);
            }
        }, handler);
    }
}

