/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;

public class HoconProcessor
implements ConfigProcessor {
    private static final String ENV_OVERRIDE_KEY = "hocon.env.override";
    private static final String RAW_DATA_KEY = "raw-data";

    public String name() {
        return "hocon";
    }

    public Future<JsonObject> process(Vertx vertx, JsonObject configuration, Buffer input) {
        return vertx.executeBlocking(() -> {
            try (StringReader reader = new StringReader(input.toString("UTF-8"));){
                Config conf = ConfigFactory.parseReader((Reader)reader);
                conf = conf.resolve();
                String output = conf.root().render(ConfigRenderOptions.concise().setJson(true).setComments(false).setFormatted(false));
                JsonObject json = new JsonObject(output);
                if (configuration != null && configuration.getBoolean(ENV_OVERRIDE_KEY, Boolean.valueOf(false)).booleanValue()) {
                    JsonObject envOverrideJson = new JsonObject();
                    ConfigFactory.systemEnvironmentOverrides().entrySet().forEach(e -> JsonObjectHelper.put((JsonObject)envOverrideJson, (String)((String)e.getKey()), (String)((ConfigValue)e.getValue()).unwrapped().toString(), (boolean)configuration.getBoolean(RAW_DATA_KEY, Boolean.valueOf(false))));
                    if (!envOverrideJson.isEmpty()) {
                        json = json.mergeIn(envOverrideJson);
                    }
                }
                JsonObject jsonObject = json;
                return jsonObject;
            }
        });
    }
}

