/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.kubernetes;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConfigMapStore
implements ConfigStore {
    private static final String KUBERNETES_NAMESPACE = System.getenv("KUBERNETES_NAMESPACE");
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final VertxInternal vertx;
    private final JsonObject configuration;
    private final String namespace;
    private final String name;
    private final String key;
    private final boolean secret;
    private final boolean optional;
    private final WebClient client;
    private String token;

    public ConfigMapStore(Vertx vertx, JsonObject configuration) {
        String p;
        this.vertx = (VertxInternal)vertx;
        this.configuration = configuration;
        String ns = configuration.getString("namespace");
        if (ns == null) {
            ns = KUBERNETES_NAMESPACE != null ? KUBERNETES_NAMESPACE : "default";
        }
        this.optional = configuration.getBoolean("optional", Boolean.valueOf(true));
        this.namespace = ns;
        this.name = configuration.getString("name");
        this.key = configuration.getString("key");
        this.secret = configuration.getBoolean("secret", Boolean.valueOf(false));
        int port = configuration.getInteger("port", Integer.valueOf(0));
        if (port == 0) {
            port = configuration.getBoolean("ssl", Boolean.valueOf(true)) != false ? 443 : 80;
        }
        if ((p = System.getenv("KUBERNETES_SERVICE_PORT")) != null) {
            port = Integer.valueOf(p);
        }
        String host = configuration.getString("host");
        String h = System.getenv("KUBERNETES_SERVICE_HOST");
        if (h != null) {
            host = h;
        }
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions().setTrustAll(true).setSsl(configuration.getBoolean("ssl", Boolean.valueOf(true)).booleanValue()).setDefaultHost(host).setDefaultPort(port).setFollowRedirects(true));
        Objects.requireNonNull(this.name);
    }

    public Future<Void> close() {
        if (this.client != null) {
            this.client.close();
        }
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    private Future<String> getToken() {
        String token = this.configuration.getString("token");
        if (token != null && !token.trim().isEmpty()) {
            this.token = token;
            return this.vertx.getOrCreateContext().succeededFuture((Object)token);
        }
        return this.vertx.fileSystem().readFile("/var/run/secrets/kubernetes.io/serviceaccount/token").recover(throwable -> this.optional ? Future.succeededFuture((Object)Buffer.buffer()) : Future.failedFuture((Throwable)throwable)).map(Buffer::toString).onSuccess(tk -> {
            this.token = tk;
        });
    }

    public Future<Buffer> get() {
        Future retrieveToken = this.token == null ? this.getToken() : this.vertx.getOrCreateContext().succeededFuture((Object)this.token);
        return retrieveToken.flatMap(token -> {
            if (token.isEmpty()) {
                return Future.succeededFuture((Object)Buffer.buffer((String)"{}"));
            }
            String path = "/api/v1/namespaces/" + this.namespace;
            path = this.secret ? path + "/secrets/" + this.name : path + "/configmaps/" + this.name;
            return this.client.get(path).putHeader("Authorization", "Bearer " + token).send().flatMap(response -> {
                if (response.statusCode() == 404) {
                    return this.handle404();
                }
                if (response.statusCode() == 403) {
                    return this.handle403();
                }
                if (response.statusCode() != 200) {
                    return this.handleOtherErrors((HttpResponse<Buffer>)response);
                }
                return this.handle200((HttpResponse<Buffer>)response);
            });
        });
    }

    private Future<Buffer> handle404() {
        if (this.optional) {
            return Future.succeededFuture((Object)Buffer.buffer((String)"{}"));
        }
        return Future.failedFuture((String)("Cannot find the config map '" + this.name + "' in '" + this.namespace + "'"));
    }

    private Future<Buffer> handle403() {
        return Future.failedFuture((String)("Access denied to configmap or secret in namespace " + this.namespace + ": " + this.name));
    }

    private Future<Buffer> handleOtherErrors(HttpResponse<Buffer> response) {
        if (this.optional) {
            return Future.succeededFuture((Object)Buffer.buffer((String)"{}"));
        }
        return Future.failedFuture((String)("Cannot retrieve the configmap or secret in namespace " + this.namespace + ": " + this.name + ", status code: " + response.statusCode() + ", error: " + response.bodyAsString()));
    }

    private Future<Buffer> handle200(HttpResponse<Buffer> response) {
        JsonObject data = response.bodyAsJsonObject().getJsonObject("data");
        if (data == null) {
            return Future.failedFuture((String)("Invalid secret of configmap in namespace " + this.namespace + " " + this.name + ", the data entry is empty"));
        }
        if (this.key == null) {
            if (this.secret) {
                return Future.succeededFuture((Object)new JsonObject(ConfigMapStore.asSecretObjectMap(data.getMap())).toBuffer());
            }
            return Future.succeededFuture((Object)new JsonObject(ConfigMapStore.asObjectMap(data.getMap())).toBuffer());
        }
        String string = data.getString(this.key);
        if (string == null) {
            return Future.failedFuture((String)("Cannot find key '" + this.key + "' in the configmap or secret '" + this.name + "'"));
        }
        if (this.secret) {
            return Future.succeededFuture((Object)Buffer.buffer((byte[])DECODER.decode(string)));
        }
        return Future.succeededFuture((Object)Buffer.buffer((String)string));
    }

    private static Map<String, Object> asObjectMap(Map<String, Object> source) {
        if (source == null) {
            return new HashMap<String, Object>();
        }
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonObjectHelper.convert((String)entry.getValue().toString())));
    }

    private static Map<String, Object> asSecretObjectMap(Map<String, Object> source) {
        if (source == null) {
            return new HashMap<String, Object>();
        }
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            String encodedString = entry.getValue().toString();
            String decodedString = new String(DECODER.decode(encodedString), StandardCharsets.UTF_8);
            return JsonObjectHelper.convert((String)decodedString);
        }));
    }
}

