/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.redis;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RedisConfigStore
implements ConfigStore {
    private static final Future CLOSED_FUTURE = Future.failedFuture((String)"Closed");
    private final Context ctx;
    private final RedisOptions options;
    private final String field;
    private Future<RedisConnection> fut;
    private List<Handler<AsyncResult<Buffer>>> waiters;
    private boolean closed;

    public RedisConfigStore(Vertx vertx, JsonObject config) {
        this.ctx = vertx.getOrCreateContext();
        this.field = config.getString("key", "configuration");
        this.options = new RedisOptions(config);
    }

    public void close(Handler<Void> completionHandler) {
        if (Vertx.currentContext() == this.ctx) {
            if (!this.closed) {
                this.closed = true;
                if (this.fut != null) {
                    ((RedisConnection)this.fut.result()).close();
                }
            }
            completionHandler.handle(null);
        } else {
            this.ctx.runOnContext(v -> this.close(completionHandler));
        }
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        if (Vertx.currentContext() == this.ctx) {
            if (this.fut == null) {
                if (this.closed) {
                    completionHandler.handle((Object)CLOSED_FUTURE);
                } else {
                    Promise promise = Promise.promise();
                    this.fut = promise.future();
                    this.waiters = new ArrayList<Handler<AsyncResult<Buffer>>>();
                    this.waiters.add(completionHandler);
                    this.fut.setHandler(ar -> {
                        if (this.closed) {
                            if (ar.succeeded()) {
                                ((RedisConnection)ar.result()).close();
                            }
                            ar = Future.failedFuture((String)"Closed");
                        }
                        List<Handler<AsyncResult<Buffer>>> list = this.waiters;
                        this.waiters = null;
                        if (ar.succeeded()) {
                            RedisConnection redis = (RedisConnection)ar.result();
                            list.forEach(waiter -> this.send(redis, (Handler<AsyncResult<Buffer>>)waiter));
                        } else {
                            this.fut = null;
                            AsyncResult failure = ar.mapEmpty();
                            list.forEach(waiter -> this.ctx.runOnContext(v -> waiter.handle((Object)failure)));
                        }
                    });
                    Redis redis = Redis.createClient((Vertx)this.ctx.owner(), (RedisOptions)this.options);
                    redis.connect((Handler)promise);
                }
            } else if (this.fut.succeeded()) {
                this.send((RedisConnection)this.fut.result(), completionHandler);
            } else {
                this.waiters.add(completionHandler);
            }
        } else {
            this.ctx.runOnContext(v -> this.get(completionHandler));
        }
    }

    private void send(RedisConnection redis, Handler<AsyncResult<Buffer>> completionHandler) {
        redis.send(Request.cmd((Command)Command.HGETALL).arg(this.field), ar -> completionHandler.handle((Object)ar.map(resp -> {
            JsonObject result = new JsonObject();
            Iterator it = resp.iterator();
            while (it.hasNext()) {
                String key = ((Response)it.next()).toString();
                String value = ((Response)it.next()).toString();
                result.put(key, (Object)value);
            }
            return result.toBuffer();
        })));
    }
}

