/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.redis;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.Iterator;

public class RedisConfigStore
implements ConfigStore {
    private final Context ctx;
    private final Redis redis;
    private final String field;
    private boolean closed;

    public RedisConfigStore(Vertx vertx, JsonObject config) {
        this.ctx = vertx.getOrCreateContext();
        this.field = config.getString("key", "configuration");
        this.redis = Redis.createClient((Vertx)vertx, (RedisOptions)new RedisOptions(config));
    }

    public void close(Handler<Void> completionHandler) {
        if (Vertx.currentContext() == this.ctx) {
            if (!this.closed) {
                this.closed = true;
                this.redis.close();
            }
            completionHandler.handle(null);
        } else {
            this.ctx.runOnContext(v -> this.close(completionHandler));
        }
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        if (Vertx.currentContext() == this.ctx) {
            this.redis.send(Request.cmd((Command)Command.HGETALL).arg(this.field), ar -> completionHandler.handle((Object)ar.map(resp -> {
                JsonObject result = new JsonObject();
                Iterator it = resp.iterator();
                while (it.hasNext()) {
                    String key = ((Response)it.next()).toString();
                    String value = ((Response)it.next()).toString();
                    result.put(key, (Object)value);
                }
                return result.toBuffer();
            })));
        } else {
            this.ctx.runOnContext(v -> this.get(completionHandler));
        }
    }
}

