/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.redis;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.Iterator;

public class RedisConfigStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final Redis redis;
    private final String field;
    private boolean closed;

    public RedisConfigStore(Vertx vertx, JsonObject config) {
        this.vertx = (VertxInternal)vertx;
        this.field = config.getString("key", "configuration");
        this.redis = Redis.createClient((Vertx)vertx, (RedisOptions)new RedisOptions(config));
    }

    public Future<Void> close() {
        this.redis.close();
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    public Future<Buffer> get() {
        return this.redis.send(Request.cmd((Command)Command.HGETALL).arg(this.field)).map(resp -> {
            JsonObject result = new JsonObject();
            Iterator it = resp.iterator();
            while (it.hasNext()) {
                String key = ((Response)it.next()).toString();
                String value = ((Response)it.next()).toString();
                result.put(key, (Object)value);
            }
            return result.toBuffer();
        });
    }
}

