/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.redis;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;

public class RedisConfigStore
implements ConfigStore {
    private final Redis redis;
    private final String field;

    public RedisConfigStore(Vertx vertx, JsonObject config) {
        this.field = config.getString("key", "configuration");
        this.redis = Redis.createClient((Vertx)vertx, (RedisOptions)new RedisOptions(config));
    }

    public Future<Void> close() {
        this.redis.close();
        return Future.succeededFuture();
    }

    public Future<Buffer> get() {
        return this.redis.send(Request.cmd((Command)Command.HGETALL).arg(this.field)).map(resp -> {
            JsonObject result = new JsonObject();
            for (String key : resp.getKeys()) {
                result.put(key, (Object)resp.get(key).toString());
            }
            return result.toBuffer();
        });
    }
}

