/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.spring;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.Objects;

class SpringConfigServerStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final String path;
    private final String authHeaderValue;
    private final HttpClient client;
    private final long timeout;

    SpringConfigServerStore(Vertx vertx, JsonObject configuration) {
        this.vertx = (VertxInternal)vertx;
        String url = configuration.getString("url");
        this.timeout = configuration.getLong("timeout", Long.valueOf(3000L));
        Objects.requireNonNull(url);
        HttpClientOptions options = new HttpClientOptions(configuration.getJsonObject("httpClientConfiguration", new JsonObject()));
        try {
            URL u = new URL(url);
            options.setDefaultHost(u.getHost());
            if (u.getPort() == -1) {
                options.setDefaultPort(u.getDefaultPort());
            } else {
                options.setDefaultPort(u.getPort());
            }
            this.path = u.getPath() != null ? u.getPath() : "/";
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid url for the spring server: " + url);
        }
        this.authHeaderValue = configuration.getString("user") != null && configuration.getString("password") != null ? "Basic " + Base64.getEncoder().encodeToString((configuration.getString("user") + ":" + configuration.getString("password")).getBytes()) : null;
        this.client = vertx.createHttpClient(options);
    }

    public Future<Void> close() {
        this.client.close();
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    public Future<Buffer> get() {
        RequestOptions options = new RequestOptions().setURI(this.path).setTimeout(this.timeout);
        if (this.authHeaderValue != null) {
            options.addHeader("Authorization", this.authHeaderValue);
        }
        return this.client.request(options).flatMap(request -> request.send().flatMap(response -> {
            if (response.statusCode() != 200) {
                return Future.failedFuture((String)("Invalid response from server: " + response.statusCode() + " - " + response.statusMessage()));
            }
            return response.body().map(Buffer::toJsonObject).flatMap(this::parse);
        }));
    }

    private Future<Buffer> parse(JsonObject body) {
        return this.path.endsWith(".json") ? this.parseFromJson(body) : this.parseFromStandard(body);
    }

    private Future<Buffer> parseFromStandard(JsonObject body) {
        JsonArray sources = body.getJsonArray("propertySources");
        if (sources == null) {
            return Future.failedFuture((String)"Invalid configuration server response, property sources missing");
        }
        JsonObject configuration = new JsonObject();
        for (int i = sources.size() - 1; i >= 0; --i) {
            JsonObject source = sources.getJsonObject(i);
            JsonObject content = source.getJsonObject("source");
            configuration = configuration.mergeIn(content, true);
        }
        return Future.succeededFuture((Object)Buffer.buffer((String)configuration.encode()));
    }

    private Future<Buffer> parseFromJson(JsonObject body) {
        return body == null ? Future.failedFuture((String)"Invalid configuration server response, property sources missing") : Future.succeededFuture((Object)Buffer.buffer((String)body.encode()));
    }
}

