/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault.client;

import io.vertx.config.vault.client.TokenRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class TokenRequestConverter {
    public static void fromJson(JsonObject json, TokenRequest obj) {
        if (json.getValue("displayName") instanceof String) {
            obj.setDisplayName((String)json.getValue("displayName"));
        }
        if (json.getValue("id") instanceof String) {
            obj.setId((String)json.getValue("id"));
        }
        if (json.getValue("meta") instanceof JsonObject) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            json.getJsonObject("meta").forEach(entry -> {
                if (entry.getValue() instanceof String) {
                    map.put((String)entry.getKey(), (String)entry.getValue());
                }
            });
            obj.setMeta(map);
        }
        if (json.getValue("noDefaultPolicy") instanceof Boolean) {
            obj.setNoDefaultPolicy((Boolean)json.getValue("noDefaultPolicy"));
        }
        if (json.getValue("noParent") instanceof Boolean) {
            obj.setNoParent((Boolean)json.getValue("noParent"));
        }
        if (json.getValue("numUses") instanceof Number) {
            obj.setNumUses(((Number)json.getValue("numUses")).longValue());
        }
        if (json.getValue("policies") instanceof JsonArray) {
            ArrayList<String> list = new ArrayList<String>();
            json.getJsonArray("policies").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setPolicies(list);
        }
        if (json.getValue("role") instanceof String) {
            obj.setRole((String)json.getValue("role"));
        }
        if (json.getValue("ttl") instanceof String) {
            obj.setTTL((String)json.getValue("ttl"));
        }
    }

    public static void toJson(TokenRequest obj, JsonObject json) {
        if (obj.getDisplayName() != null) {
            json.put("displayName", obj.getDisplayName());
        }
        if (obj.getId() != null) {
            json.put("id", obj.getId());
        }
        if (obj.getMeta() != null) {
            JsonObject map = new JsonObject();
            obj.getMeta().forEach((key, value) -> map.put(key, value));
            json.put("meta", map);
        }
        json.put("noDefaultPolicy", Boolean.valueOf(obj.isNoDefaultPolicy()));
        json.put("noParent", Boolean.valueOf(obj.isNoParent()));
        json.put("numUses", Long.valueOf(obj.getNumUses()));
        if (obj.getPolicies() != null) {
            JsonArray array = new JsonArray();
            obj.getPolicies().forEach(item -> array.add(item));
            json.put("policies", array);
        }
        if (obj.getRole() != null) {
            json.put("role", obj.getRole());
        }
        if (obj.getTtl() != null) {
            json.put("ttl", obj.getTtl());
        }
    }
}

