/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Auth {
    @JsonProperty(value="accessor")
    private String accessor;
    @JsonProperty(value="lease_duration")
    private long leaseDuration;
    @JsonProperty(value="renewable")
    private boolean renewable;
    private JsonObject metadata;
    @JsonProperty(value="client_token")
    private String token;
    @JsonProperty(value="policies")
    private List<String> policies;

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    private void setMetadata(Map<String, Object> meta) {
        this.metadata = new JsonObject(meta);
    }

    public String getToken() {
        return this.token;
    }

    public List<String> getPolicies() {
        return this.policies;
    }

    public String getApplicationId() {
        return this.getMetadata() != null ? this.getMetadata().getString("app-id") : null;
    }

    public String getUserId() {
        return this.getMetadata() != null ? this.getMetadata().getString("user-id") : null;
    }

    public String getUsername() {
        return this.getMetadata() != null ? this.getMetadata().getString("username") : null;
    }

    public String getAccessor() {
        return this.accessor;
    }

    public String toString() {
        return "Auth{accessor='" + this.accessor + '\'' + ", leaseDuration=" + this.leaseDuration + ", renewable=" + this.renewable + ", metadata=" + this.metadata + ", token='" + this.token + '\'' + ", policies=" + this.policies + '}';
    }
}

