/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.vault.client.Auth;
import io.vertx.config.vault.client.Secret;
import io.vertx.config.vault.client.SlimVaultClient;
import io.vertx.config.vault.client.TokenRequest;
import io.vertx.config.vault.client.VaultException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Objects;

public class VaultConfigStore
implements ConfigStore {
    private final SlimVaultClient client;
    private final JsonObject config;
    private final String path;
    private final Vertx vertx;
    private boolean renewable;
    private long validity;
    private Context context;

    public VaultConfigStore(Vertx vertx, JsonObject config) {
        this.client = new SlimVaultClient(vertx, config);
        this.config = config;
        this.vertx = vertx;
        this.path = Objects.requireNonNull(config.getString("path"), "The path of the secret must be set");
    }

    public void close(Handler<Void> completionHandler) {
        this.client.close();
        completionHandler.handle(null);
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        if (this.context == null) {
            this.context = this.vertx.getOrCreateContext();
        }
        Handler actions = x -> this.authenticate(false).compose(v -> this.renew()).compose(v -> this.retrieve()).compose(this::extract).setHandler(completionHandler);
        if (Vertx.currentContext() == this.context) {
            actions.handle(null);
        } else {
            this.context.runOnContext(actions);
        }
    }

    private Future<Buffer> extract(JsonObject json) {
        Promise promise = Promise.promise();
        if (json == null) {
            promise.complete((Object)new JsonObject().toBuffer());
        } else if (this.config.getString("key") != null) {
            Object value = json.getValue(this.config.getString("key"));
            if (value == null) {
                promise.complete((Object)new JsonObject().toBuffer());
            } else if (value instanceof String) {
                promise.complete((Object)Buffer.buffer((String)((String)value)));
            } else if (value instanceof JsonObject) {
                promise.complete((Object)((JsonObject)value).toBuffer());
            }
        } else {
            promise.complete((Object)json.toBuffer());
        }
        return promise.future();
    }

    private Future<JsonObject> retrieve() {
        Promise promise = Promise.promise();
        this.client.read(this.path, (Handler<AsyncResult<Secret>>)((Handler)ar -> {
            if (ar.failed() && !(ar.cause() instanceof VaultException)) {
                promise.fail(ar.cause());
            } else if (ar.failed() && ((VaultException)ar.cause()).getStatusCode() == 404) {
                promise.complete(null);
            } else if (ar.failed()) {
                promise.fail(ar.cause());
            } else {
                Secret result = (Secret)ar.result();
                JsonObject copy = result.getData().copy();
                copy.put("vault-lease-id", result.getLeaseId());
                copy.put("vault-lease-duration", Long.valueOf(result.getLeaseDuration()));
                copy.put("vault-renewable", Boolean.valueOf(result.isRenewable()));
                promise.complete((Object)copy);
            }
        }));
        return promise.future();
    }

    private Future<Void> renew() {
        Promise promise = Promise.promise();
        if (this.validity == 0L) {
            promise.complete();
        } else {
            if (this.shouldBeRenewed() && this.renewable) {
                return this.renewToken();
            }
            if (this.shouldBeRenewed()) {
                return this.authenticate(true);
            }
            promise.complete();
        }
        return promise.future();
    }

    private Future<Void> renewToken() {
        Promise promise = Promise.promise();
        this.client.renewSelf(this.config.getLong("lease-duration", Long.valueOf(3600L)), (Handler<AsyncResult<Auth>>)((Handler)auth -> this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth)));
        return promise.future();
    }

    private Future<Void> authenticate(boolean renew) {
        Promise promise = Promise.promise();
        if (!renew && this.client.getToken() != null) {
            promise.complete();
            return promise.future();
        }
        String policy = this.config.getString("auth-backend");
        Objects.requireNonNull(policy, "If you don't provide a token, the auth-backend must be set");
        switch (policy.toLowerCase()) {
            case "token": {
                return this.loginWithToken();
            }
            case "approle": {
                return this.loginWithAppRole();
            }
            case "cert": {
                return this.loginWithCert();
            }
            case "userpass": {
                return this.loginWithUserName();
            }
        }
        throw new IllegalArgumentException("Non supported auth-backend: " + policy);
    }

    private Future<Void> loginWithUserName() {
        Promise promise = Promise.promise();
        JsonObject req = this.config.getJsonObject("user-credentials");
        Objects.requireNonNull(req, "When using username, the `user-credentials` must be set in the configuration");
        String username = req.getString("username");
        String password = req.getString("password");
        String token = req.getString("token");
        Objects.requireNonNull(username, "When using userpass, the username must be set in the `user-credentials` configuration");
        Objects.requireNonNull(password, "When using userpass, the password must be set in the `user-credentials` configuration");
        this.client.loginWithUserCredentials(username, password, (Handler<AsyncResult<Auth>>)((Handler)auth -> this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth)));
        return promise.future();
    }

    private Future<Void> loginWithCert() {
        Promise promise = Promise.promise();
        this.client.loginWithCert((Handler<AsyncResult<Auth>>)((Handler)auth -> this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth)));
        return promise.future();
    }

    private Future<Void> loginWithAppRole() {
        Promise promise = Promise.promise();
        JsonObject req = this.config.getJsonObject("approle");
        Objects.requireNonNull(req, "When using approle, the `app-role` must be set in the configuration");
        String roleId = req.getString("role-id");
        String secretId = req.getString("secret-id");
        Objects.requireNonNull(roleId, "When using approle, the role-id must be set in the `approle` configuration");
        Objects.requireNonNull(secretId, "When using approle, the secret-id must be set in the `approle` configuration");
        this.client.loginWithAppRole(roleId, secretId, (Handler<AsyncResult<Auth>>)((Handler)auth -> this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth)));
        return promise.future();
    }

    private Future<Void> loginWithToken() {
        Promise promise = Promise.promise();
        JsonObject req = this.config.getJsonObject("token-request");
        Objects.requireNonNull(req, "When using a token creation policy, the `token-request` must be set in the configuration");
        String token = req.getString("token");
        Objects.requireNonNull(req, "When using a token creation policy, the `token-request` must be set in the configuration and contains the `token` entry with the original token");
        this.client.setToken(token).createToken(new TokenRequest(req), (Handler<AsyncResult<Auth>>)((Handler)auth -> this.manageAuthenticationResult((Promise<Void>)promise, (AsyncResult<Auth>)auth)));
        return promise.future();
    }

    private void manageAuthenticationResult(Promise<Void> future, AsyncResult<Auth> auth) {
        if (auth.failed()) {
            future.fail(auth.cause());
        } else {
            Auth authentication = (Auth)auth.result();
            if (authentication.getToken() == null) {
                future.fail("Authentication failed, the token is null");
            } else {
                this.client.setToken(authentication.getToken());
                this.renewable = authentication.isRenewable();
                this.validity = System.currentTimeMillis() + authentication.getLeaseDuration() * 1000L;
                future.complete();
            }
        }
    }

    private boolean shouldBeRenewed() {
        long margin;
        long now = System.currentTimeMillis();
        return now >= this.validity - (margin = this.config.getLong("renew-window", Long.valueOf(60000L)).longValue());
    }

    public SlimVaultClient getVaultClient() {
        return this.client;
    }
}

