/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.config.vault.client.TokenRequestConverter;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class TokenRequest {
    private String id;
    private List<String> policies;
    private Map<String, String> meta;
    private boolean noParent;
    private boolean noDefaultPolicy;
    private String ttl;
    private String displayName;
    private long numUses;
    private String role;

    public TokenRequest() {
    }

    public TokenRequest(JsonObject json) {
        TokenRequestConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public TokenRequest(TokenRequest other) {
        this.id = other.id;
        this.policies = other.policies;
        this.meta = other.meta;
        this.noParent = other.noParent;
        this.noDefaultPolicy = other.noDefaultPolicy;
        this.ttl = other.ttl;
        this.displayName = other.displayName;
        this.numUses = other.numUses;
        this.role = other.role;
    }

    public String getId() {
        return this.id;
    }

    public TokenRequest setId(String id) {
        this.id = id;
        return this;
    }

    public List<String> getPolicies() {
        return this.policies;
    }

    public TokenRequest setPolicies(List<String> policies) {
        this.policies = policies;
        return this;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public TokenRequest setMeta(Map<String, String> meta) {
        this.meta = meta;
        return this;
    }

    public boolean isNoParent() {
        return this.noParent;
    }

    public TokenRequest setNoParent(boolean noParent) {
        this.noParent = noParent;
        return this;
    }

    public boolean isNoDefaultPolicy() {
        return this.noDefaultPolicy;
    }

    public TokenRequest setNoDefaultPolicy(boolean noDefaultPolicy) {
        this.noDefaultPolicy = noDefaultPolicy;
        return this;
    }

    public String getTtl() {
        return this.ttl;
    }

    public TokenRequest setTTL(String ttl) {
        this.ttl = ttl;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TokenRequest setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public long getNumUses() {
        return this.numUses;
    }

    public TokenRequest setNumUses(long numUses) {
        this.numUses = numUses;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public TokenRequest setRole(String role) {
        this.role = role;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        TokenRequestConverter.toJson(this, json);
        return json;
    }

    public JsonObject toPayload() {
        JsonObject payload = new JsonObject();
        if (this.getId() != null) {
            payload.put("id", (Object)this.getId());
        }
        if (this.getPolicies() != null && !this.getPolicies().isEmpty()) {
            JsonArray policies = new JsonArray();
            this.getPolicies().forEach(arg_0 -> ((JsonArray)policies).add(arg_0));
            payload.put("policies", (Object)policies);
        }
        if (this.getMeta() != null && !this.getMeta().isEmpty()) {
            JsonObject meta = new JsonObject();
            this.getMeta().forEach((arg_0, arg_1) -> ((JsonObject)meta).put(arg_0, arg_1));
            payload.put("meta", (Object)meta);
        }
        if (this.isNoParent()) {
            payload.put("no_parent", (Object)this.isNoParent());
        }
        if (this.isNoDefaultPolicy()) {
            payload.put("no_default_policy", (Object)this.isNoDefaultPolicy());
        }
        if (this.getTtl() != null) {
            payload.put("ttl", (Object)this.getTtl());
        }
        if (this.getDisplayName() != null) {
            payload.put("display_name", (Object)this.getDisplayName());
        }
        if (this.getNumUses() != 0L) {
            payload.put("num_uses", (Object)this.getNumUses());
        }
        return payload;
    }
}

