/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault.client;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TokenRequest {
    private String id;
    private List<String> policies;
    private Map<String, String> meta;
    private boolean noParent;
    private boolean noDefaultPolicy;
    private String ttl;
    private String displayName;
    private long numUses;
    private String role;

    public TokenRequest() {
    }

    public TokenRequest(JsonObject json) {
        TokenRequest.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getId() {
        return this.id;
    }

    public TokenRequest setId(String id) {
        this.id = id;
        return this;
    }

    public List<String> getPolicies() {
        return this.policies;
    }

    public TokenRequest setPolicies(List<String> policies) {
        this.policies = policies;
        return this;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public TokenRequest setMeta(Map<String, String> meta) {
        this.meta = meta;
        return this;
    }

    public boolean isNoParent() {
        return this.noParent;
    }

    public TokenRequest setNoParent(boolean noParent) {
        this.noParent = noParent;
        return this;
    }

    public boolean isNoDefaultPolicy() {
        return this.noDefaultPolicy;
    }

    public TokenRequest setNoDefaultPolicy(boolean noDefaultPolicy) {
        this.noDefaultPolicy = noDefaultPolicy;
        return this;
    }

    public String getTtl() {
        return this.ttl;
    }

    public TokenRequest setTTL(String ttl) {
        this.ttl = ttl;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TokenRequest setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public long getNumUses() {
        return this.numUses;
    }

    public TokenRequest setNumUses(long numUses) {
        this.numUses = numUses;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public TokenRequest setRole(String role) {
        this.role = role;
        return this;
    }

    public JsonObject toPayload() {
        JsonObject payload = new JsonObject();
        if (this.getId() != null) {
            payload.put("id", (Object)this.getId());
        }
        if (this.getPolicies() != null && !this.getPolicies().isEmpty()) {
            JsonArray policies = new JsonArray();
            this.getPolicies().forEach(arg_0 -> ((JsonArray)policies).add(arg_0));
            payload.put("policies", (Object)policies);
        }
        if (this.getMeta() != null && !this.getMeta().isEmpty()) {
            JsonObject meta = new JsonObject();
            this.getMeta().forEach((arg_0, arg_1) -> ((JsonObject)meta).put(arg_0, arg_1));
            payload.put("meta", (Object)meta);
        }
        if (this.isNoParent()) {
            payload.put("no_parent", (Object)this.isNoParent());
        }
        if (this.isNoDefaultPolicy()) {
            payload.put("no_default_policy", (Object)this.isNoDefaultPolicy());
        }
        if (this.getTtl() != null) {
            payload.put("ttl", (Object)this.getTtl());
        }
        if (this.getDisplayName() != null) {
            payload.put("display_name", (Object)this.getDisplayName());
        }
        if (this.getNumUses() != 0L) {
            payload.put("num_uses", (Object)this.getNumUses());
        }
        return payload;
    }

    private static void fromJson(Iterable<Map.Entry<String, Object>> json, TokenRequest obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "displayName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDisplayName((String)member.getValue());
                    break;
                }
                case "id": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setId((String)member.getValue());
                    break;
                }
                case "meta": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setMeta(map);
                    break;
                }
                case "noDefaultPolicy": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNoDefaultPolicy((Boolean)member.getValue());
                    break;
                }
                case "noParent": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNoParent((Boolean)member.getValue());
                    break;
                }
                case "numUses": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setNumUses(((Number)member.getValue()).longValue());
                    break;
                }
                case "policies": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setPolicies(list);
                    break;
                }
                case "role": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRole((String)member.getValue());
                    break;
                }
                case "ttl": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTTL((String)member.getValue());
                }
            }
        }
    }
}

