/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.zookeeper;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.KeeperException;

public class ZookeeperConfigStore
implements ConfigStore {
    private final CuratorFramework client;
    private final String path;
    private final VertxInternal vertx;

    public ZookeeperConfigStore(Vertx vertx, JsonObject configuration) {
        String connection = Objects.requireNonNull(configuration.getString("connection"));
        this.path = Objects.requireNonNull(configuration.getString("path"));
        this.vertx = (VertxInternal)Objects.requireNonNull(vertx);
        int maxRetries = configuration.getInteger("maxRetries", Integer.valueOf(3));
        int baseGraceBetweenRetries = configuration.getInteger("baseSleepTimeBetweenRetries", Integer.valueOf(1000));
        this.client = CuratorFrameworkFactory.newClient((String)connection, (RetryPolicy)new ExponentialBackoffRetry(baseGraceBetweenRetries, maxRetries));
        this.client.start();
    }

    public Future<Buffer> get() {
        return this.vertx.executeBlocking(promise -> {
            try {
                this.client.blockUntilConnected();
                promise.complete();
            }
            catch (InterruptedException e) {
                promise.fail((Throwable)e);
            }
        }).flatMap(v -> {
            PromiseInternal promise = this.vertx.promise();
            try {
                ((ErrorListenerPathable)this.client.getData().inBackground((arg_0, arg_1) -> this.lambda$null$1((Promise)promise, arg_0, arg_1))).withUnhandledErrorListener((arg_0, arg_1) -> ZookeeperConfigStore.lambda$null$2((Promise)promise, arg_0, arg_1)).forPath(this.path);
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
            return promise.future();
        });
    }

    private void retrieve(CuratorEvent event, Promise<Buffer> promise) {
        KeeperException.Code code = KeeperException.Code.get((int)event.getResultCode());
        if (code == KeeperException.Code.OK) {
            promise.complete((Object)Buffer.buffer((byte[])event.getData()));
        } else if (code == KeeperException.Code.NONODE) {
            promise.complete((Object)Buffer.buffer((String)"{}"));
        } else {
            promise.fail((Throwable)KeeperException.create((KeeperException.Code)code, (String)this.path));
        }
    }

    public Future<Void> close() {
        this.client.close();
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    private static /* synthetic */ void lambda$null$2(Promise promise, String message, Throwable e) {
        promise.fail((Throwable)new Exception(message, e));
    }

    private /* synthetic */ void lambda$null$1(Promise promise, CuratorFramework client, CuratorEvent event) throws Exception {
        this.retrieve(event, (Promise<Buffer>)promise);
    }
}

