/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.config;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.rxjava.core.Future;
import io.vertx.config.ConfigChange;

/**
 * Defines a configuration retriever that read configuration from
 * 
 * and tracks changes periodically.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.config.ConfigRetriever original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.config.ConfigRetriever.class)
public class ConfigRetriever {

  public static final io.vertx.lang.rxjava.TypeArg<ConfigRetriever> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new ConfigRetriever((io.vertx.config.ConfigRetriever) obj),
    ConfigRetriever::getDelegate
  );

  private final io.vertx.config.ConfigRetriever delegate;
  
  public ConfigRetriever(io.vertx.config.ConfigRetriever delegate) {
    this.delegate = delegate;
  }

  public io.vertx.config.ConfigRetriever getDelegate() {
    return delegate;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.rxjava.config.ConfigRetriever}.
   * @param vertx the vert.x instance
   * @param options the options, must not be <code>null</code>, must contain the list of configured store.
   * @return the created instance.
   */
  public static ConfigRetriever create(Vertx vertx, ConfigRetrieverOptions options) { 
    ConfigRetriever ret = ConfigRetriever.newInstance(io.vertx.config.ConfigRetriever.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.rxjava.config.ConfigRetriever}, using the default
   * settings (json file, system properties and environment variables).
   * @param vertx the vert.x instance
   * @return the created instance.
   */
  public static ConfigRetriever create(Vertx vertx) { 
    ConfigRetriever ret = ConfigRetriever.newInstance(io.vertx.config.ConfigRetriever.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava.config.ConfigRetriever#getConfig}, but returning a  object. The result is a
   * .
   * @param retriever the config retrieve
   * @return the future completed when the configuration is retrieved
   */
  public static Future<JsonObject> getConfigAsFuture(ConfigRetriever retriever) { 
    Future<JsonObject> ret = Future.newInstance(io.vertx.config.ConfigRetriever.getConfigAsFuture(retriever.getDelegate()), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Reads the configuration from the different 
   * and computes the final configuration.
   * @param completionHandler handler receiving the computed configuration, or a failure if the configuration cannot be retrieved
   */
  public void getConfig(Handler<AsyncResult<JsonObject>> completionHandler) { 
    delegate.getConfig(completionHandler);
  }

  /**
   * Reads the configuration from the different 
   * and computes the final configuration.
   * @return 
   */
  public Single<JsonObject> rxGetConfig() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getConfig(fut);
    }));
  }

  /**
   * Closes the retriever.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Gets the last computed configuration.
   * @return the last configuration
   */
  public JsonObject getCachedConfig() { 
    JsonObject ret = delegate.getCachedConfig();
    return ret;
  }

  /**
   * Registers a listener receiving configuration changes. This method cannot only be called if
   * the configuration is broadcasted.
   * @param listener the listener
   */
  public void listen(Handler<ConfigChange> listener) { 
    delegate.listen(listener);
  }

  /**
   * @return the stream of configurations. It's single stream (unicast) and that delivers the last known config and the successors periodically.
   */
  public ReadStream<JsonObject> configStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    ReadStream<JsonObject> ret = ReadStream.newInstance(delegate.configStream(), io.vertx.lang.rxjava.TypeArg.unknown());
    cached_0 = ret;
    return ret;
  }

  private ReadStream<JsonObject> cached_0;

  public static ConfigRetriever newInstance(io.vertx.config.ConfigRetriever arg) {
    return arg != null ? new ConfigRetriever(arg) : null;
  }
}
