/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.config.ConfigChange;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.config.impl.ConfigRetrieverImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;

@VertxGen
public interface ConfigRetriever {
    public static ConfigRetriever create(Vertx vertx, ConfigRetrieverOptions options) {
        ConfigRetrieverImpl retriever = new ConfigRetrieverImpl(vertx, options);
        retriever.initializePeriodicScan();
        return retriever;
    }

    public static ConfigRetriever create(Vertx vertx) {
        ConfigRetrieverOptions options = new ConfigRetrieverOptions();
        options.addStore(new ConfigStoreOptions().setType("json").setConfig(vertx.getOrCreateContext().config())).addStore(new ConfigStoreOptions().setType("sys")).addStore(new ConfigStoreOptions().setType("env"));
        return ConfigRetriever.create(vertx, options);
    }

    public static Future<JsonObject> getConfigAsFuture(ConfigRetriever retriever) {
        Future future = Future.future();
        retriever.getConfig((Handler<AsyncResult<JsonObject>>)future.completer());
        return future;
    }

    public void getConfig(Handler<AsyncResult<JsonObject>> var1);

    public void close();

    public JsonObject getCachedConfig();

    public void listen(Handler<ConfigChange> var1);

    @CacheReturn
    public ReadStream<JsonObject> configStream();
}

