/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;

public class ConfigurationProvider {
    private final JsonObject configuration;
    private final ConfigStore store;
    private final ConfigProcessor processor;

    public ConfigurationProvider(ConfigStore store, ConfigProcessor processor, JsonObject config) {
        this.store = store;
        this.processor = processor;
        this.configuration = config == null ? new JsonObject() : config;
    }

    void get(Vertx vertx, Handler<AsyncResult<JsonObject>> completionHandler) {
        this.store.get((Handler<AsyncResult<Buffer>>)((Handler)maybeBuffer -> {
            if (maybeBuffer.failed()) {
                completionHandler.handle((Object)Future.failedFuture((Throwable)maybeBuffer.cause()));
            } else {
                this.processor.process(vertx, this.configuration, (Buffer)maybeBuffer.result(), (Handler<AsyncResult<JsonObject>>)((Handler)maybeJson -> {
                    if (maybeJson.failed()) {
                        completionHandler.handle((Object)Future.failedFuture((Throwable)maybeJson.cause()));
                    } else {
                        completionHandler.handle((Object)Future.succeededFuture((Object)maybeJson.result()));
                    }
                }));
            }
        }));
    }

    void close(Handler<Void> handler) {
        this.store.close(handler);
    }

    public ConfigStore getStore() {
        return this.store;
    }

    public ConfigProcessor getProcessor() {
        return this.processor;
    }
}

