/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.ConfigStoreFactory;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Map;

public class EnvVariablesConfigStore
implements ConfigStoreFactory,
ConfigStore {
    private final boolean rawData;
    private JsonObject cached;

    public EnvVariablesConfigStore() {
        this(false);
    }

    public EnvVariablesConfigStore(boolean rawData) {
        this.rawData = rawData;
    }

    @Override
    public String name() {
        return "env";
    }

    @Override
    public ConfigStore create(Vertx vertx, JsonObject configuration) {
        return new EnvVariablesConfigStore(configuration.getBoolean("raw-data", Boolean.valueOf(false)));
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        if (this.cached == null) {
            this.cached = EnvVariablesConfigStore.all(System.getenv(), this.rawData);
        }
        completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)this.cached.encode())));
    }

    private static JsonObject all(Map<String, String> env, boolean rawData) {
        JsonObject json = new JsonObject();
        env.entrySet().stream().forEach(entry -> JsonObjectHelper.put(json, (String)entry.getKey(), (String)entry.getValue(), rawData));
        return json;
    }
}

