/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.spi.utils;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.utils.Processors;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.launcher.commands.FileSelector;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;

public class FileSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSet.class);
    private final String pattern;
    private final ConfigProcessor processor;
    private final File root;
    private final Vertx vertx;
    private final Boolean rawData;

    public FileSet(Vertx vertx, File root, JsonObject set) {
        this.vertx = vertx;
        this.root = root;
        this.pattern = set.getString("pattern");
        if (this.pattern == null) {
            throw new IllegalArgumentException("Each file set needs to contain a `pattern`");
        }
        this.rawData = set.getBoolean("raw-data", Boolean.valueOf(false));
        String format = set.getString("format", "json");
        this.processor = Processors.get(format);
        if (this.processor == null) {
            throw new IllegalArgumentException("Unknown configuration format `" + format + "`, supported types are " + Processors.getSupportedFormats());
        }
    }

    private boolean matches(String path) {
        return FileSelector.match((String)this.pattern, (String)path, (boolean)false);
    }

    public void buildConfiguration(List<File> files, Handler<AsyncResult<JsonObject>> handler) {
        ArrayList futures = new ArrayList();
        files.stream().map(file -> {
            String relative = null;
            if (file.getAbsolutePath().startsWith(this.root.getAbsolutePath())) {
                relative = file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
            }
            if (relative == null) {
                LOGGER.warn((Object)("The file `" + file.getAbsolutePath() + "` is not in '" + this.root.getAbsolutePath() + "'"));
            }
            return relative;
        }).filter(Objects::nonNull).filter(this::matches).map(s -> new File(this.root, (String)s)).forEach(file -> {
            Future future = Future.future();
            futures.add(future);
            try {
                this.vertx.fileSystem().readFile(file.getAbsolutePath(), buffer -> {
                    if (buffer.failed()) {
                        future.fail(buffer.cause());
                    } else {
                        this.processor.process(this.vertx, new JsonObject().put("raw-data", this.rawData), (Buffer)buffer.result(), (Handler<AsyncResult<JsonObject>>)future.completer());
                    }
                });
            }
            catch (RejectedExecutionException e) {
                future.fail((Throwable)e);
            }
        });
        CompositeFuture.all(futures).setHandler(ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                JsonObject result = new JsonObject();
                futures.stream().map(future -> (JsonObject)future.result()).forEach(arg_0 -> ((JsonObject)result).mergeIn(arg_0));
                handler.handle((Object)Future.succeededFuture((Object)result));
            }
        });
    }

    public static List<File> traverse(File root) {
        ArrayList<File> files = new ArrayList<File>();
        if (!root.isDirectory()) {
            return files;
        }
        File[] children = root.listFiles();
        if (children == null) {
            return files;
        }
        for (File file : children) {
            if (file.isDirectory()) {
                files.addAll(FileSet.traverse(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }
}

