/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.atomic.AtomicReference;

public class EventBusConfigStore
implements ConfigStore {
    private final MessageConsumer<Object> consumer;
    private AtomicReference<Buffer> last = new AtomicReference();

    public EventBusConfigStore(Vertx vertx, String address) {
        this.consumer = vertx.eventBus().consumer(address);
        this.consumer.handler(message -> {
            Object body = message.body();
            if (body instanceof JsonObject) {
                this.last.set(((JsonObject)body).toBuffer());
            } else if (body instanceof Buffer) {
                this.last.set((Buffer)body);
            }
        });
    }

    @Override
    public void close(Handler<Void> completionHandler) {
        this.consumer.unregister(ar -> completionHandler.handle(null));
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        Buffer buffer = this.last.get();
        if (buffer != null) {
            completionHandler.handle((Object)Future.succeededFuture((Object)buffer));
        } else {
            completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)"{}")));
        }
    }
}

