/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.config.ConfigChange;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.impl.ConfigRetrieverImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import java.util.function.Function;

@VertxGen
public interface ConfigRetriever {
    public static ConfigRetriever create(Vertx vertx, ConfigRetrieverOptions options) {
        ConfigRetrieverImpl retriever = new ConfigRetrieverImpl(vertx, options);
        retriever.initializePeriodicScan();
        return retriever;
    }

    public static ConfigRetriever create(Vertx vertx) {
        return ConfigRetriever.create(vertx, new ConfigRetrieverOptions().setIncludeDefaultStores(true));
    }

    public static Future<JsonObject> getConfigAsFuture(ConfigRetriever retriever) {
        Promise promise = Promise.promise();
        retriever.getConfig((Handler<AsyncResult<JsonObject>>)promise);
        return promise.future();
    }

    public void getConfig(Handler<AsyncResult<JsonObject>> var1);

    public void close();

    public JsonObject getCachedConfig();

    public void listen(Handler<ConfigChange> var1);

    @Fluent
    public ConfigRetriever setBeforeScanHandler(Handler<Void> var1);

    @Fluent
    public ConfigRetriever setConfigurationProcessor(Function<JsonObject, JsonObject> var1);

    @CacheReturn
    public ReadStream<JsonObject> configStream();
}

