/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.ConfigStoreFactory;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EnvVariablesConfigStore
implements ConfigStoreFactory,
ConfigStore {
    private final boolean rawData;
    private final Set<String> keys;
    private JsonObject cached;

    public EnvVariablesConfigStore() {
        this(false, null);
    }

    public EnvVariablesConfigStore(boolean rawData, JsonArray keys) {
        this.rawData = rawData;
        this.keys = keys == null ? null : new HashSet(keys.getList());
    }

    @Override
    public String name() {
        return "env";
    }

    @Override
    public ConfigStore create(Vertx vertx, JsonObject configuration) {
        return new EnvVariablesConfigStore(configuration.getBoolean("raw-data", Boolean.valueOf(false)), configuration.getJsonArray("keys"));
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        if (this.cached == null) {
            this.cached = EnvVariablesConfigStore.all(System.getenv(), this.rawData, this.keys);
        }
        completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)this.cached.encode())));
    }

    private static JsonObject all(Map<String, String> env, boolean rawData, Set<String> keys) {
        JsonObject json = new JsonObject();
        Set<String> localKeys = keys == null ? env.keySet() : keys;
        env.forEach((key, value) -> {
            if (localKeys.contains(key)) {
                JsonObjectHelper.put(json, key, value, rawData);
            }
        });
        return json;
    }
}

