/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;

public class RawProcessor
implements ConfigProcessor {
    @Override
    public String name() {
        return "raw";
    }

    @Override
    public void process(Vertx vertx, JsonObject configuration, Buffer input, Handler<AsyncResult<JsonObject>> handler) {
        String key = configuration.getString("raw.key");
        String type = configuration.getString("raw.type", "string");
        if (key == null) {
            handler.handle((Object)Future.failedFuture((String)"The `raw.key` is required in the configuration when using the `raw` processor."));
        } else {
            JsonObject json = new JsonObject();
            try {
                switch (type) {
                    case "string": {
                        json.put(key, (Object)input.toString(configuration.getString("raw.encoding", "utf-8")));
                        handler.handle((Object)Future.succeededFuture((Object)json));
                        break;
                    }
                    case "json-object": {
                        json.put(key, (Object)input.toJsonObject());
                        handler.handle((Object)Future.succeededFuture((Object)json));
                        break;
                    }
                    case "json-array": {
                        json.put(key, (Object)input.toJsonArray());
                        handler.handle((Object)Future.succeededFuture((Object)json));
                        break;
                    }
                    case "binary": {
                        json.put(key, (Object)input.getBytes());
                        handler.handle((Object)Future.succeededFuture((Object)json));
                        break;
                    }
                    default: {
                        handler.handle((Object)Future.failedFuture((String)("Unrecognized `raw.type` : " + type)));
                        break;
                    }
                }
            }
            catch (Exception e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }
    }
}

