/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl;

import io.vertx.config.ConfigChange;
import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.config.impl.ConfigurationProvider;
import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.ConfigStoreFactory;
import io.vertx.config.spi.utils.Processors;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConfigRetrieverImpl
implements ConfigRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRetrieverImpl.class);
    private static final String DEFAULT_CONFIG_PATH = "conf" + File.separator + "config.json";
    private final Vertx vertx;
    private final List<ConfigurationProvider> providers;
    private long scan;
    private final List<Handler<ConfigChange>> listeners = new ArrayList<Handler<ConfigChange>>();
    private final ConfigStreamImpl streamOfConfiguration = new ConfigStreamImpl();
    private final ConfigRetrieverOptions options;
    private JsonObject current = new JsonObject();
    private Handler<Void> beforeScan;
    private Function<JsonObject, JsonObject> processor;

    public ConfigRetrieverImpl(Vertx vertx, ConfigRetrieverOptions options) {
        this.vertx = vertx;
        this.options = options;
        ServiceLoader<ConfigStoreFactory> storeImpl = ServiceLoader.load(ConfigStoreFactory.class, ConfigStoreFactory.class.getClassLoader());
        HashMap nameToImplMap = new HashMap();
        storeImpl.iterator().forEachRemaining(factory -> nameToImplMap.put(factory.name(), factory));
        if (nameToImplMap.isEmpty()) {
            throw new IllegalStateException("No configuration store implementations found on the classpath");
        }
        List<ConfigStoreOptions> stores = options.getStores();
        if (options.isIncludeDefaultStores()) {
            stores = new ArrayList<ConfigStoreOptions>();
            stores.add(new ConfigStoreOptions().setType("json").setConfig(vertx.getOrCreateContext().config()));
            stores.add(new ConfigStoreOptions().setType("sys"));
            stores.add(new ConfigStoreOptions().setType("env"));
            String defaultConfigPath = this.getDefaultConfigPath();
            if (defaultConfigPath != null && !defaultConfigPath.trim().isEmpty()) {
                String format = ConfigRetrieverImpl.extractFormatFromFileExtension(defaultConfigPath);
                LOGGER.info((Object)("Config file path: " + defaultConfigPath + ", format:" + format));
                stores.add(new ConfigStoreOptions().setType("file").setFormat(format).setOptional(true).setConfig(new JsonObject().put("path", (Object)defaultConfigPath)));
            }
            stores.addAll(options.getStores());
        }
        this.providers = new ArrayList<ConfigurationProvider>();
        for (ConfigStoreOptions option : stores) {
            String type = option.getType();
            if (type == null) {
                throw new IllegalArgumentException("the `type` entry is mandatory in a configuration store configuration");
            }
            ConfigStoreFactory factory2 = (ConfigStoreFactory)nameToImplMap.get(type);
            if (factory2 == null) {
                throw new IllegalArgumentException("unknown configuration store implementation: " + type + " (known implementations are: " + nameToImplMap.keySet() + ")");
            }
            JsonObject config = option.getConfig();
            if (config == null) {
                config = new JsonObject();
            }
            ConfigStore store = factory2.create(vertx, config);
            String format = option.getFormat() != null ? option.getFormat() : "json";
            ConfigProcessor processor = Processors.get(format);
            if (processor == null) {
                throw new IllegalArgumentException("unknown configuration format: " + format + " (supported formats are: " + Processors.getSupportedFormats());
            }
            this.providers.add(new ConfigurationProvider(store, processor, option.getConfig(), option.isOptional()));
        }
    }

    static String extractFormatFromFileExtension(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return "json";
        }
        String ext = path.substring(index + 1);
        if (ext.trim().isEmpty()) {
            return "json";
        }
        if ("yml".equalsIgnoreCase(ext)) {
            ext = "yaml";
        }
        return ext.toLowerCase();
    }

    private String getDefaultConfigPath() {
        boolean exists;
        String value = System.getenv("VERTX_CONFIG_PATH");
        if (value == null || value.trim().isEmpty()) {
            value = System.getProperty("vertx-config-path");
        }
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        File file = ((VertxInternal)this.vertx).resolveFile(DEFAULT_CONFIG_PATH);
        boolean bl = exists = file != null && file.exists();
        if (exists) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public synchronized void initializePeriodicScan() {
        this.scan = this.options.getScanPeriod() > 0L ? this.vertx.setPeriodic(this.options.getScanPeriod(), l -> this.scan()) : -1L;
    }

    @Override
    public void getConfig(Handler<AsyncResult<JsonObject>> completionHandler) {
        Objects.requireNonNull(completionHandler);
        this.compute((Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
            if (ar.succeeded()) {
                ConfigRetrieverImpl configRetrieverImpl = this;
                synchronized (configRetrieverImpl) {
                    this.current = (JsonObject)ar.result();
                    this.streamOfConfiguration.handle(this.current);
                }
            }
            completionHandler.handle(ar);
        }));
    }

    @Override
    public Future<JsonObject> getConfig() {
        Promise promise = Promise.promise();
        this.getConfig((Handler<AsyncResult<JsonObject>>)promise);
        return promise.future();
    }

    @Override
    public synchronized void close() {
        if (this.scan != -1L) {
            this.vertx.cancelTimer(this.scan);
        }
        this.streamOfConfiguration.close();
        for (ConfigurationProvider provider : this.providers) {
            provider.close((Handler<Void>)((Handler)v -> {}));
        }
    }

    @Override
    public synchronized JsonObject getCachedConfig() {
        return this.current.copy();
    }

    @Override
    public void listen(Handler<ConfigChange> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public ConfigRetriever setBeforeScanHandler(Handler<Void> handler) {
        this.beforeScan = Objects.requireNonNull(handler, "The handler must not be `null`");
        return this;
    }

    @Override
    public ConfigRetriever setConfigurationProcessor(Function<JsonObject, JsonObject> processor) {
        this.processor = Objects.requireNonNull(processor, "The processor must not be `null`");
        return this;
    }

    @Override
    public ReadStream<JsonObject> configStream() {
        return this.streamOfConfiguration;
    }

    private void scan() {
        if (this.beforeScan != null) {
            this.beforeScan.handle(null);
        }
        this.compute((Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
            if (ar.failed()) {
                this.streamOfConfiguration.fail(ar.cause());
                LOGGER.error((Object)"Error while scanning configuration", ar.cause());
            } else {
                ConfigRetrieverImpl configRetrieverImpl = this;
                synchronized (configRetrieverImpl) {
                    if (!this.current.equals(ar.result())) {
                        JsonObject prev = this.current;
                        this.current = (JsonObject)ar.result();
                        this.listeners.forEach(l -> l.handle((Object)new ConfigChange(prev, this.current)));
                        try {
                            this.streamOfConfiguration.handle(this.current);
                        }
                        catch (Throwable e) {
                            if (this.vertx.exceptionHandler() != null) {
                                this.vertx.exceptionHandler().handle((Object)e);
                            }
                            throw e;
                        }
                    }
                }
            }
        }));
    }

    private void compute(Handler<AsyncResult<JsonObject>> completionHandler) {
        List futures = this.providers.stream().map(s -> {
            Promise conf = Promise.promise();
            s.get(this.vertx, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    conf.tryComplete(ar.result());
                } else {
                    conf.tryFail(ar.cause());
                }
            }));
            return conf.future();
        }).collect(Collectors.toList());
        CompositeFuture.all(futures).onComplete(r -> {
            if (r.failed()) {
                try {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)r.cause()));
                }
                catch (Throwable e) {
                    if (this.vertx.exceptionHandler() != null) {
                        this.vertx.exceptionHandler().handle((Object)e);
                    }
                    throw e;
                }
            } else {
                JsonObject json = new JsonObject();
                futures.forEach(future -> json.mergeIn((JsonObject)future.result(), true));
                try {
                    JsonObject computed = json;
                    if (this.processor != null) {
                        this.processConfigurationAndReport(completionHandler, json);
                    } else {
                        completionHandler.handle((Object)Future.succeededFuture((Object)computed));
                    }
                }
                catch (Throwable e) {
                    if (this.vertx.exceptionHandler() != null) {
                        this.vertx.exceptionHandler().handle((Object)e);
                    }
                    throw e;
                }
            }
        });
    }

    private void processConfigurationAndReport(Handler<AsyncResult<JsonObject>> completionHandler, JsonObject json) {
        try {
            JsonObject computed = this.processor.apply(json);
            completionHandler.handle((Object)Future.succeededFuture((Object)computed));
        }
        catch (Throwable e) {
            completionHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public List<ConfigurationProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    private class ConfigStreamImpl
    implements ReadStream<JsonObject> {
        private Handler<JsonObject> handler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> endHandler;
        private JsonObject last;
        private long demand = Long.MAX_VALUE;

        private ConfigStreamImpl() {
        }

        public synchronized ReadStream<JsonObject> exceptionHandler(Handler<Throwable> handler) {
            Objects.requireNonNull(handler);
            this.exceptionHandler = handler;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReadStream<JsonObject> handler(Handler<JsonObject> handler) {
            JsonObject conf;
            Objects.requireNonNull(handler);
            ConfigStreamImpl configStreamImpl = this;
            synchronized (configStreamImpl) {
                this.handler = handler;
                conf = ConfigRetrieverImpl.this.getCachedConfig();
            }
            if (conf != null && !conf.isEmpty()) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> this.handler.handle((Object)conf));
            }
            return this;
        }

        public synchronized ReadStream<JsonObject> pause() {
            this.demand = 0L;
            return this;
        }

        public synchronized ReadStream<JsonObject> resume() {
            boolean check = this.demand == 0L;
            this.demand = Long.MAX_VALUE;
            if (check) {
                this.checkPending();
            }
            return this;
        }

        public synchronized ReadStream<JsonObject> fetch(long amount) {
            boolean check = this.demand == 0L;
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            if (check) {
                this.checkPending();
            }
            return this;
        }

        private void checkPending() {
            Handler<JsonObject> succ = this.handler;
            JsonObject conf = this.last;
            this.last = null;
            if (conf != null) {
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                if (succ != null) {
                    ConfigRetrieverImpl.this.vertx.runOnContext(v -> succ.handle((Object)conf));
                }
            }
        }

        public synchronized ReadStream<JsonObject> endHandler(Handler<Void> endHandler) {
            Objects.requireNonNull(endHandler);
            this.endHandler = endHandler;
            return this;
        }

        synchronized void handle(JsonObject conf) {
            boolean isPaused;
            Handler<JsonObject> succ = this.handler;
            boolean bl = isPaused = this.demand == 0L;
            if (isPaused) {
                this.last = conf;
            } else if (this.demand < Long.MAX_VALUE) {
                --this.demand;
            }
            if (!isPaused && succ != null) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> succ.handle((Object)conf));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fail(Throwable cause) {
            Handler<Throwable> err;
            ConfigStreamImpl configStreamImpl = this;
            synchronized (configStreamImpl) {
                err = this.exceptionHandler;
            }
            if (err != null) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> err.handle((Object)cause));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Handler<Void> handler;
            ConfigStreamImpl configStreamImpl = this;
            synchronized (configStreamImpl) {
                handler = this.endHandler;
            }
            if (handler != null) {
                ConfigRetrieverImpl.this.vertx.runOnContext(v -> handler.handle(null));
            }
        }
    }
}

