/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;

public class ConfigurationProvider {
    private final JsonObject configuration;
    private final boolean optional;
    private final ConfigStore store;
    private final ConfigProcessor processor;
    private final Logger logger;

    public ConfigurationProvider(ConfigStore store, ConfigProcessor processor, JsonObject config, boolean optional) {
        this.store = store;
        this.processor = processor;
        this.optional = optional;
        this.configuration = config == null ? new JsonObject() : config;
        this.logger = LoggerFactory.getLogger((String)("ConfigurationProvider#" + store));
    }

    void get(Vertx vertx, Handler<AsyncResult<JsonObject>> completionHandler) {
        this.store.get((Handler<AsyncResult<Buffer>>)((Handler)maybeBuffer -> {
            if (maybeBuffer.failed()) {
                if (this.optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Unable to retrieve the configuration", maybeBuffer.cause());
                    }
                    completionHandler.handle((Object)Future.succeededFuture((Object)new JsonObject()));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)maybeBuffer.cause()));
                }
            } else {
                this.processor.process(vertx, this.configuration, (Buffer)maybeBuffer.result(), (Handler<AsyncResult<JsonObject>>)((Handler)maybeJson -> {
                    if (maybeJson.failed()) {
                        if (this.optional) {
                            this.logger.warn((Object)("Unable to process the retrieve the configuration " + maybeJson.cause().getMessage()));
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)"Failure caught when processing the configuration", maybeJson.cause());
                            }
                            completionHandler.handle((Object)Future.succeededFuture((Object)new JsonObject()));
                        } else {
                            completionHandler.handle((Object)Future.failedFuture((Throwable)maybeJson.cause()));
                        }
                    } else {
                        completionHandler.handle((Object)Future.succeededFuture((Object)maybeJson.result()));
                    }
                }));
            }
        }));
    }

    void close(Handler<Void> handler) {
        this.store.close(handler);
    }

    public ConfigStore getStore() {
        return this.store;
    }

    public ConfigProcessor getProcessor() {
        return this.processor;
    }
}

