/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.FileSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DirectoryConfigStore
implements ConfigStore {
    private Vertx vertx;
    private File path;
    private final List<FileSet> filesets = new ArrayList<FileSet>();

    public DirectoryConfigStore(Vertx vertx, JsonObject configuration) {
        this.vertx = vertx;
        String thePath = configuration.getString("path");
        if (thePath == null) {
            throw new IllegalArgumentException("The `path` configuration is required.");
        }
        this.path = new File(thePath);
        if (this.path.isFile()) {
            throw new IllegalArgumentException("The `path` must not be a file");
        }
        JsonArray files = configuration.getJsonArray("filesets");
        if (files == null) {
            throw new IllegalArgumentException("The `filesets` element is required.");
        }
        for (Object o : files) {
            JsonObject json = (JsonObject)o;
            FileSet set = new FileSet(vertx, this.path, json);
            this.filesets.add(set);
        }
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.vertx.executeBlocking(fut -> {
            try {
                fut.complete(FileSet.traverse(this.path).stream().sorted().collect(Collectors.toList()));
            }
            catch (Throwable e) {
                fut.fail(e);
            }
        }, ar -> {
            if (ar.failed()) {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                ArrayList<Future> futures = new ArrayList<Future>();
                for (FileSet set : this.filesets) {
                    Promise promise = Promise.promise();
                    set.buildConfiguration((List)ar.result(), (Handler<AsyncResult<JsonObject>>)((Handler)json -> {
                        if (json.failed()) {
                            promise.fail(json.cause());
                        } else {
                            promise.complete(json.result());
                        }
                    }));
                    futures.add(promise.future());
                }
                CompositeFuture.all(futures).onComplete(cf -> {
                    if (cf.failed()) {
                        completionHandler.handle((Object)Future.failedFuture((Throwable)cf.cause()));
                    } else {
                        JsonObject json = new JsonObject();
                        futures.stream().map(f -> (JsonObject)f.result()).forEach(config -> json.mergeIn(config, true));
                        completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)json.encode())));
                    }
                });
            }
        });
    }
}

