/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonObject;

public class HttpConfigStore
implements ConfigStore {
    private final HttpClient client;
    private final RequestOptions requestOptions;

    public HttpConfigStore(Vertx vertx, JsonObject configuration) {
        String host = configuration.getString("host");
        int port = configuration.getInteger("port", Integer.valueOf(80));
        String path = configuration.getString("path", "/");
        long timeout = configuration.getLong("timeout", Long.valueOf(3000L));
        boolean followRedirects = configuration.getBoolean("followRedirects", Boolean.valueOf(false));
        this.client = vertx.createHttpClient(new HttpClientOptions(configuration));
        this.requestOptions = new RequestOptions().setHost(host).setPort(Integer.valueOf(port)).setURI(path).setTimeout(timeout).setFollowRedirects(Boolean.valueOf(followRedirects));
        configuration.getJsonObject("headers", new JsonObject()).stream().filter(h -> h.getValue() != null).forEach(h -> this.requestOptions.addHeader((String)h.getKey(), h.getValue().toString()));
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.client.get(this.requestOptions, ar -> {
            if (ar.succeeded()) {
                HttpClientResponse response = (HttpClientResponse)ar.result();
                response.exceptionHandler(t -> completionHandler.handle((Object)Future.failedFuture((Throwable)t))).bodyHandler(buffer -> completionHandler.handle((Object)Future.succeededFuture((Object)buffer)));
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    @Override
    public void close(Handler<Void> completionHandler) {
        this.client.close();
        completionHandler.handle(null);
    }
}

