/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertiesConfigProcessor
implements ConfigProcessor {
    private static final PropertiesReader FLAT_READER = new FlatPropertiesReader();
    private static final PropertiesReader HIERARCHICAL_READER = new HierarchicalPropertiesReader();

    @Override
    public String name() {
        return "properties";
    }

    @Override
    public Future<JsonObject> process(Vertx vertx, JsonObject configuration, Buffer input) {
        Boolean hierarchicalData = configuration.getBoolean("hierarchical", Boolean.valueOf(false));
        PropertiesReader reader = hierarchicalData != false ? HIERARCHICAL_READER : FLAT_READER;
        boolean rawData = configuration.getBoolean("raw-data", Boolean.valueOf(false));
        return vertx.executeBlocking(future -> {
            byte[] bytes = input.getBytes();
            try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
                JsonObject created = reader.readAsJson(rawData, stream);
                future.complete((Object)created);
            }
            catch (Exception e) {
                future.fail((Throwable)e);
            }
        });
    }

    private static class HierarchicalPropertiesReader
    implements PropertiesReader {
        private HierarchicalPropertiesReader() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public JsonObject readAsJson(boolean rawData, InputStream byteStream) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private JsonObject toJson(Stream<String> stream) {
            return stream.filter(line -> !(line = line.trim()).isEmpty() && !line.startsWith("#") && !line.startsWith("!")).map(line -> line.split("=")).map(raw -> {
                String property = raw[0].trim();
                Object value = this.tryParse(raw[1].trim());
                List<String> paths = Arrays.asList(property.split("\\."));
                if (paths.size() == 1) {
                    return new JsonObject().put(property, value);
                }
                JsonObject json = this.toJson(paths.subList(1, paths.size()), value);
                return new JsonObject().put(paths.get(0), (Object)json);
            }).reduce((json, other) -> json.mergeIn(other, true)).orElse(new JsonObject());
        }

        private JsonObject toJson(List<String> paths, Object value) {
            if (paths.size() == 0) {
                return new JsonObject();
            }
            if (paths.size() == 1) {
                return new JsonObject().put(paths.get(0), value);
            }
            String path = paths.get(0);
            JsonObject jsonValue = this.toJson(paths.subList(1, paths.size()), value);
            return new JsonObject().put(path, (Object)jsonValue);
        }

        private Object tryParse(String raw) {
            if (raw.contains(",")) {
                return Stream.of(raw.split(",")).map(this::tryParse).collect(Collectors.collectingAndThen(Collectors.toList(), JsonArray::new));
            }
            if ("true".equals(raw)) {
                return true;
            }
            if ("false".equals(raw)) {
                return false;
            }
            if (raw.matches("^\\d+\\.\\d+$")) {
                return Double.parseDouble(raw);
            }
            if (raw.matches("^\\d+$")) {
                return Integer.parseInt(raw);
            }
            return raw;
        }
    }

    private static class FlatPropertiesReader
    implements PropertiesReader {
        private FlatPropertiesReader() {
        }

        @Override
        public JsonObject readAsJson(boolean rawData, InputStream byteStream) throws IOException {
            Properties properties = new Properties();
            properties.load(byteStream);
            return JsonObjectHelper.from(properties, rawData);
        }
    }

    private static interface PropertiesReader {
        public JsonObject readAsJson(boolean var1, InputStream var2) throws IOException;
    }
}

