/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class EnvVariablesConfigStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final boolean rawData;
    private final Set<String> keys;
    private final AtomicReference<Buffer> cached = new AtomicReference();

    public EnvVariablesConfigStore(Vertx vertx, boolean rawData, JsonArray keys) {
        this.vertx = (VertxInternal)vertx;
        this.rawData = rawData;
        this.keys = keys == null ? null : new HashSet(keys.getList());
    }

    @Override
    public Future<Buffer> get() {
        Buffer value = this.cached.get();
        if (value == null) {
            value = EnvVariablesConfigStore.all(System.getenv(), this.rawData, this.keys).toBuffer();
            this.cached.set(value);
        }
        return this.vertx.getOrCreateContext().succeededFuture((Object)value);
    }

    private static JsonObject all(Map<String, String> env, boolean rawData, Set<String> keys) {
        JsonObject json = new JsonObject();
        Set<String> localKeys = keys == null ? env.keySet() : keys;
        env.forEach((key, value) -> {
            if (localKeys.contains(key)) {
                JsonObjectHelper.put(json, key, value, rawData);
            }
        });
        return json;
    }

    @Override
    public Future<Void> close() {
        return this.vertx.getOrCreateContext().succeededFuture();
    }
}

