/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.spi.utils;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Properties;

public class JsonObjectHelper {
    @Deprecated
    public static Buffer toBuffer(JsonObject json) {
        return json.toBuffer();
    }

    public static void put(JsonObject json, String name, String value, boolean rawData) {
        json.put(name, rawData ? value : JsonObjectHelper.convert(value));
    }

    public static Object convert(String value) {
        Objects.requireNonNull(value);
        Boolean bool = JsonObjectHelper.asBoolean(value);
        if (bool != null) {
            return bool;
        }
        Object number = JsonObjectHelper.asNumber(value);
        if (number != null) {
            return number;
        }
        JsonObject obj = JsonObjectHelper.asJsonObject(value);
        if (obj != null) {
            return obj;
        }
        JsonArray arr = JsonObjectHelper.asJsonArray(value);
        if (arr != null) {
            return arr;
        }
        return value;
    }

    private static Object asNumber(String s) {
        try {
            return new BigInteger(s);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new BigDecimal(s);
            }
            catch (NumberFormatException numberFormatException2) {
                return null;
            }
        }
    }

    private static Boolean asBoolean(String s) {
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static JsonObject asJsonObject(String s) {
        if (s.startsWith("{") && s.endsWith("}")) {
            try {
                return new JsonObject(s);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static JsonArray asJsonArray(String s) {
        if (s.startsWith("[") && s.endsWith("]")) {
            try {
                return new JsonArray(s);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static JsonObject from(Properties props) {
        return JsonObjectHelper.from(props, false);
    }

    public static JsonObject from(Properties props, boolean rawData) {
        JsonObject json = new JsonObject();
        props.stringPropertyNames().forEach(name -> JsonObjectHelper.put(json, name, props.getProperty((String)name), rawData));
        return json;
    }
}

