/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Objects;

@DataObject
public class ConfigStoreOptions {
    private String type;
    private JsonObject config;
    private String format;
    private boolean optional;

    public ConfigStoreOptions() {
    }

    public ConfigStoreOptions(ConfigStoreOptions other) {
        this.type = other.type;
        this.config = other.config == null ? null : other.config.copy();
        this.format = other.format;
        this.optional = other.optional;
    }

    public ConfigStoreOptions(JsonObject json) {
        this.type = json.getString("type");
        this.config = json.getJsonObject("config");
        this.optional = json.getBoolean("optional", Boolean.valueOf(false));
        this.format = json.getString("format", "json");
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.type != null) {
            json.put("type", (Object)this.type);
        }
        if (this.config != null) {
            json.put("config", (Object)this.config);
        }
        if (this.format != null) {
            json.put("format", (Object)this.format);
        }
        json.put("optional", (Object)this.optional);
        return json;
    }

    public String getType() {
        return this.type;
    }

    public ConfigStoreOptions setType(String type) {
        this.type = type;
        return this;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public ConfigStoreOptions setConfig(JsonObject config) {
        this.config = config;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public ConfigStoreOptions setOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public ConfigStoreOptions setFormat(String format) {
        Objects.requireNonNull(format);
        this.format = format;
        return this;
    }
}

