/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config;

import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class ConfigRetrieverOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ConfigRetrieverOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "includeDefaultStores": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setIncludeDefaultStores((Boolean)member.getValue());
                    break;
                }
                case "scanPeriod": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setScanPeriod(((Number)member.getValue()).longValue());
                    break;
                }
                case "stores": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<ConfigStoreOptions> list = new ArrayList<ConfigStoreOptions>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new ConfigStoreOptions((JsonObject)item));
                        }
                    });
                    obj.setStores(list);
                }
            }
        }
    }

    static void toJson(ConfigRetrieverOptions obj, JsonObject json) {
        ConfigRetrieverOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(ConfigRetrieverOptions obj, Map<String, Object> json) {
        json.put("includeDefaultStores", obj.isIncludeDefaultStores());
        json.put("scanPeriod", obj.getScanPeriod());
        if (obj.getStores() != null) {
            JsonArray array = new JsonArray();
            obj.getStores().forEach(item -> array.add((Object)item.toJson()));
            json.put("stores", array);
        }
    }
}

