/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.config.ConfigRetrieverOptionsConverter;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class ConfigRetrieverOptions {
    private static final long SCAN_PERIOD_DEFAULT = 5000L;
    private long scanPeriod = 5000L;
    private List<ConfigStoreOptions> stores = new ArrayList<ConfigStoreOptions>();
    private boolean includeDefaultStores = false;

    public ConfigRetrieverOptions() {
    }

    public ConfigRetrieverOptions(ConfigRetrieverOptions other) {
        this.scanPeriod = other.scanPeriod;
        this.stores = other.stores;
    }

    public ConfigRetrieverOptions(JsonObject json) {
        ConfigRetrieverOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ConfigRetrieverOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isIncludeDefaultStores() {
        return this.includeDefaultStores;
    }

    public ConfigRetrieverOptions setIncludeDefaultStores(boolean includeDefaultStores) {
        this.includeDefaultStores = includeDefaultStores;
        return this;
    }

    public long getScanPeriod() {
        return this.scanPeriod;
    }

    public ConfigRetrieverOptions setScanPeriod(long scanPeriod) {
        this.scanPeriod = scanPeriod;
        return this;
    }

    public List<ConfigStoreOptions> getStores() {
        return this.stores;
    }

    public ConfigRetrieverOptions setStores(List<ConfigStoreOptions> stores) {
        this.stores = stores == null ? new ArrayList<ConfigStoreOptions>() : stores;
        return this;
    }

    public ConfigRetrieverOptions addStore(ConfigStoreOptions options) {
        this.getStores().add(options);
        return this;
    }
}

