/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;

public class ConfigurationProvider {
    private final JsonObject configuration;
    private final boolean optional;
    private final ConfigStore store;
    private final ConfigProcessor processor;
    private final Logger logger;

    public ConfigurationProvider(ConfigStore store, ConfigProcessor processor, JsonObject config, boolean optional) {
        this.store = store;
        this.processor = processor;
        this.optional = optional;
        this.configuration = config == null ? new JsonObject() : config;
        this.logger = LoggerFactory.getLogger((String)("ConfigurationProvider#" + store));
    }

    Future<JsonObject> get(Vertx vertx) {
        return this.store.get().onFailure(throwable -> {
            if (this.optional && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Unable to retrieve the configuration", throwable);
            }
        }).flatMap(maybeBuffer -> this.processor.process(vertx, this.configuration, (Buffer)maybeBuffer).onFailure(throwable -> {
            if (this.optional && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failure caught when processing the configuration", throwable);
            }
        })).recover(throwable -> this.optional ? Future.succeededFuture((Object)new JsonObject()) : Future.failedFuture((Throwable)throwable));
    }

    void close() {
        this.store.close();
    }

    public ConfigStore getStore() {
        return this.store;
    }

    public ConfigProcessor getProcessor() {
        return this.processor;
    }
}

