/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.atomic.AtomicReference;

public class EventBusConfigStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final MessageConsumer<Object> consumer;
    private final AtomicReference<Buffer> last = new AtomicReference();

    public EventBusConfigStore(Vertx vertx, String address) {
        this.vertx = (VertxInternal)vertx;
        this.consumer = vertx.eventBus().consumer(address);
        this.consumer.handler(message -> {
            Object body = message.body();
            if (body instanceof JsonObject) {
                this.last.set(((JsonObject)body).toBuffer());
            } else if (body instanceof Buffer) {
                this.last.set((Buffer)body);
            }
        });
    }

    @Override
    public Future<Void> close() {
        return this.consumer.unregister();
    }

    @Override
    public Future<Buffer> get() {
        Buffer buffer = this.last.get();
        ContextInternal context = this.vertx.getOrCreateContext();
        return context.succeededFuture((Object)(buffer != null ? buffer : Buffer.buffer((String)"{}")));
    }
}

