/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.FileSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DirectoryConfigStore
implements ConfigStore {
    private VertxInternal vertx;
    private File path;
    private final List<FileSet> filesets = new ArrayList<FileSet>();

    public DirectoryConfigStore(Vertx vertx, JsonObject configuration) {
        this.vertx = (VertxInternal)vertx;
        String thePath = configuration.getString("path");
        if (thePath == null) {
            throw new IllegalArgumentException("The `path` configuration is required.");
        }
        this.path = new File(thePath);
        if (this.path.isFile()) {
            throw new IllegalArgumentException("The `path` must not be a file");
        }
        JsonArray files = configuration.getJsonArray("filesets");
        if (files == null) {
            throw new IllegalArgumentException("The `filesets` element is required.");
        }
        for (Object o : files) {
            JsonObject json = (JsonObject)o;
            FileSet set = new FileSet(vertx, this.path, json);
            this.filesets.add(set);
        }
    }

    @Override
    public Future<Buffer> get() {
        return this.vertx.executeBlocking(() -> FileSet.traverse(this.path).stream().sorted().collect(Collectors.toList())).flatMap(files -> {
            ArrayList<Future> futures = new ArrayList<Future>();
            for (FileSet set : this.filesets) {
                PromiseInternal promise = this.vertx.promise();
                set.buildConfiguration((List<File>)files, (Handler<AsyncResult<JsonObject>>)((Handler)arg_0 -> DirectoryConfigStore.lambda$get$1((Promise)promise, arg_0)));
                futures.add(promise.future());
            }
            return Future.all(futures);
        }).map(compositeFuture -> {
            JsonObject json = new JsonObject();
            compositeFuture.list().forEach(config -> json.mergeIn(config, true));
            return json.toBuffer();
        });
    }

    @Override
    public Future<Void> close() {
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    private static /* synthetic */ void lambda$get$1(Promise promise, AsyncResult json) {
        if (json.failed()) {
            promise.fail(json.cause());
        } else {
            promise.complete((Object)((JsonObject)json.result()));
        }
    }
}

