/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;

public class RawProcessor
implements ConfigProcessor {
    @Override
    public String name() {
        return "raw";
    }

    @Override
    public Future<JsonObject> process(Vertx vertx, JsonObject configuration, Buffer input) {
        PromiseInternal promise = ((VertxInternal)vertx).promise();
        String key = configuration.getString("raw.key");
        String type = configuration.getString("raw.type", "string");
        if (key == null) {
            promise.fail("The `raw.key` is required in the configuration when using the `raw` processor.");
        } else {
            JsonObject json = new JsonObject();
            try {
                switch (type) {
                    case "string": {
                        json.put(key, (Object)input.toString(configuration.getString("raw.encoding", "utf-8")));
                        promise.complete((Object)json);
                        break;
                    }
                    case "json-object": {
                        json.put(key, (Object)input.toJsonObject());
                        promise.complete((Object)json);
                        break;
                    }
                    case "json-array": {
                        json.put(key, (Object)input.toJsonArray());
                        promise.complete((Object)json);
                        break;
                    }
                    case "binary": {
                        json.put(key, (Object)input.getBytes());
                        promise.complete((Object)json);
                        break;
                    }
                    default: {
                        promise.fail("Unrecognized `raw.type` : " + type);
                        break;
                    }
                }
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        }
        return promise.future();
    }
}

