/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;

public class HttpConfigStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final HttpClient client;
    private final RequestOptions requestOptions;

    public HttpConfigStore(Vertx vertx, JsonObject configuration) {
        this.vertx = (VertxInternal)vertx;
        String host = configuration.getString("host");
        int port = configuration.getInteger("port", Integer.valueOf(80));
        String path = configuration.getString("path", "/");
        long timeout = configuration.getLong("timeout", Long.valueOf(3000L));
        boolean followRedirects = configuration.getBoolean("followRedirects", Boolean.valueOf(false));
        this.client = vertx.createHttpClient(new HttpClientOptions(configuration));
        this.requestOptions = new RequestOptions().setHost(host).setPort(Integer.valueOf(port)).setURI(path).setTimeout(timeout).setFollowRedirects(Boolean.valueOf(followRedirects));
        configuration.getJsonObject("headers", new JsonObject()).stream().filter(h -> h.getValue() != null).forEach(h -> this.requestOptions.addHeader((String)h.getKey(), h.getValue().toString()));
    }

    @Override
    public Future<Buffer> get() {
        return this.client.request(this.requestOptions).flatMap(HttpClientRequest::send).flatMap(HttpClientResponse::body);
    }

    @Override
    public Future<Void> close() {
        this.client.close();
        return this.vertx.getOrCreateContext().succeededFuture();
    }
}

