/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.atomic.AtomicReference;

public class SystemPropertiesConfigStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final boolean cache;
    private final Boolean rawData;
    private final Boolean hierarchical;
    private AtomicReference<Buffer> cached = new AtomicReference();

    public SystemPropertiesConfigStore(Vertx vertx, JsonObject configuration) {
        this.vertx = (VertxInternal)vertx;
        this.cache = configuration.getBoolean("cache", Boolean.valueOf(true));
        this.rawData = configuration.getBoolean("raw-data", Boolean.valueOf(false));
        this.hierarchical = configuration.getBoolean("hierarchical", Boolean.valueOf(false));
    }

    @Override
    public Future<Buffer> get() {
        Buffer value = this.cached.get();
        if (value == null) {
            value = JsonObjectHelper.from(System.getProperties(), this.rawData, this.hierarchical).toBuffer();
            if (this.cache) {
                this.cached.set(value);
            }
        }
        return this.vertx.getOrCreateContext().succeededFuture((Object)value);
    }

    @Override
    public Future<Void> close() {
        return this.vertx.getOrCreateContext().succeededFuture();
    }
}

