/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.spi.utils;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.utils.Processors;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;

public class FileSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSet.class);
    private final String pattern;
    private final ConfigProcessor processor;
    private final File root;
    private final Vertx vertx;
    private final Boolean rawData;
    private final Boolean hierarchical;

    public FileSet(Vertx vertx, File root, JsonObject set) {
        this.vertx = vertx;
        this.root = root;
        this.pattern = set.getString("pattern");
        if (this.pattern == null) {
            throw new IllegalArgumentException("Each file set needs to contain a `pattern`");
        }
        this.rawData = set.getBoolean("raw-data", Boolean.valueOf(false));
        this.hierarchical = set.getBoolean("hierarchical", Boolean.valueOf(false));
        String format = set.getString("format", "json");
        this.processor = Processors.get(format);
        if (this.processor == null) {
            throw new IllegalArgumentException("Unknown configuration format `" + format + "`, supported types are " + String.valueOf(Processors.getSupportedFormats()));
        }
    }

    private boolean matches(String path) {
        return FileSet.match(this.pattern, path, false);
    }

    public static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        return FileSet.match(patArr, strArr, isCaseSensitive);
    }

    private static boolean match(char[] patArr, char[] strArr, boolean isCaseSensitive) {
        char ch;
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char aPatArr : patArr) {
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || FileSet.equals(ch2, strArr[i], isCaseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !FileSet.equals(ch, strArr[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return FileSet.checkOnlyStartsLeft(patArr, patIdxStart, patIdxEnd);
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !FileSet.equals(ch, strArr[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            return FileSet.checkOnlyStartsLeft(patArr, patIdxStart, patIdxEnd);
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (patArr[i] != '*') continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && !FileSet.equals(ch, strArr[strIdxStart + i + j], isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        return FileSet.checkOnlyStartsLeft(patArr, patIdxStart, patIdxEnd);
    }

    private static boolean checkOnlyStartsLeft(char[] patArr, int patIdxStart, int patIdxEnd) {
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean equals(char c1, char c2, boolean isCaseSensitive) {
        if (c1 == c2) {
            return true;
        }
        return !isCaseSensitive && (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2));
    }

    public void buildConfiguration(List<File> files, Handler<AsyncResult<JsonObject>> handler) {
        ArrayList futures = new ArrayList();
        files.stream().map(file -> {
            String relative = null;
            if (file.getAbsolutePath().startsWith(this.root.getAbsolutePath())) {
                relative = file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
            }
            if (relative == null) {
                LOGGER.warn((Object)("The file `" + file.getAbsolutePath() + "` is not in '" + this.root.getAbsolutePath() + "'"));
            }
            return relative;
        }).filter(Objects::nonNull).filter(this::matches).map(s -> new File(this.root, (String)s)).forEach(file -> {
            Promise promise = Promise.promise();
            futures.add(promise.future());
            try {
                this.vertx.fileSystem().readFile(file.getAbsolutePath()).onComplete(buffer -> {
                    if (buffer.failed()) {
                        promise.fail(buffer.cause());
                    } else {
                        this.processor.process(this.vertx, new JsonObject().put("raw-data", (Object)this.rawData).put("hierarchical", (Object)this.hierarchical), (Buffer)buffer.result()).onComplete((Completable)promise);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                promise.fail((Throwable)e);
            }
        });
        Future.all(futures).onComplete(ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                JsonObject result = new JsonObject();
                futures.stream().map(future -> (JsonObject)future.result()).forEach(config -> result.mergeIn(config, true));
                handler.handle((Object)Future.succeededFuture((Object)result));
            }
        });
    }

    public static List<File> traverse(File root) {
        ArrayList<File> files = new ArrayList<File>();
        if (!root.isDirectory()) {
            return files;
        }
        File[] children = root.listFiles();
        if (children == null) {
            return files;
        }
        for (File file : children) {
            if (file.isDirectory()) {
                files.addAll(FileSet.traverse(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }
}

