package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

/**
 * Converter and mapper for {@link io.vertx.ext.consul.ConsulClientOptions}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ConsulClientOptions} original class using Vert.x codegen.
 */
public class ConsulClientOptionsConverter {


  private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
  private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, ConsulClientOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "aclToken":
          if (member.getValue() instanceof String) {
            obj.setAclToken((String)member.getValue());
          }
          break;
        case "dc":
          if (member.getValue() instanceof String) {
            obj.setDc((String)member.getValue());
          }
          break;
        case "timeout":
          if (member.getValue() instanceof Number) {
            obj.setTimeout(((Number)member.getValue()).longValue());
          }
          break;
      }
    }
  }

   static void toJson(ConsulClientOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(ConsulClientOptions obj, java.util.Map<String, Object> json) {
    if (obj.getAclToken() != null) {
      json.put("aclToken", obj.getAclToken());
    }
    if (obj.getDc() != null) {
      json.put("dc", obj.getDc());
    }
    json.put("timeout", obj.getTimeout());
  }
}
