package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

/**
 * Converter and mapper for {@link io.vertx.ext.consul.Event}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.Event} original class using Vert.x codegen.
 */
public class EventConverter {


  private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
  private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, Event obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "id":
          if (member.getValue() instanceof String) {
            obj.setId((String)member.getValue());
          }
          break;
        case "lTime":
          if (member.getValue() instanceof Number) {
            obj.setLTime(((Number)member.getValue()).intValue());
          }
          break;
        case "name":
          if (member.getValue() instanceof String) {
            obj.setName((String)member.getValue());
          }
          break;
        case "node":
          if (member.getValue() instanceof String) {
            obj.setNode((String)member.getValue());
          }
          break;
        case "payload":
          if (member.getValue() instanceof String) {
            obj.setPayload((String)member.getValue());
          }
          break;
        case "service":
          if (member.getValue() instanceof String) {
            obj.setService((String)member.getValue());
          }
          break;
        case "tag":
          if (member.getValue() instanceof String) {
            obj.setTag((String)member.getValue());
          }
          break;
        case "version":
          if (member.getValue() instanceof Number) {
            obj.setVersion(((Number)member.getValue()).intValue());
          }
          break;
      }
    }
  }

   static void toJson(Event obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(Event obj, java.util.Map<String, Object> json) {
    if (obj.getId() != null) {
      json.put("id", obj.getId());
    }
    json.put("lTime", obj.getLTime());
    if (obj.getName() != null) {
      json.put("name", obj.getName());
    }
    if (obj.getNode() != null) {
      json.put("node", obj.getNode());
    }
    if (obj.getPayload() != null) {
      json.put("payload", obj.getPayload());
    }
    if (obj.getService() != null) {
      json.put("service", obj.getService());
    }
    if (obj.getTag() != null) {
      json.put("tag", obj.getTag());
    }
    json.put("version", obj.getVersion());
  }
}
