package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

/**
 * Converter and mapper for {@link io.vertx.ext.consul.Node}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.Node} original class using Vert.x codegen.
 */
public class NodeConverter {


  private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
  private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, Node obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "address":
          if (member.getValue() instanceof String) {
            obj.setAddress((String)member.getValue());
          }
          break;
        case "datacenter":
          if (member.getValue() instanceof String) {
            obj.setDatacenter((String)member.getValue());
          }
          break;
        case "id":
          if (member.getValue() instanceof String) {
            obj.setId((String)member.getValue());
          }
          break;
        case "lanAddress":
          if (member.getValue() instanceof String) {
            obj.setLanAddress((String)member.getValue());
          }
          break;
        case "name":
          if (member.getValue() instanceof String) {
            obj.setName((String)member.getValue());
          }
          break;
        case "nodeMeta":
          if (member.getValue() instanceof JsonObject) {
            java.util.Map<String, java.lang.String> map = new java.util.LinkedHashMap<>();
            ((Iterable<java.util.Map.Entry<String, Object>>)member.getValue()).forEach(entry -> {
              if (entry.getValue() instanceof String)
                map.put(entry.getKey(), (String)entry.getValue());
            });
            obj.setNodeMeta(map);
          }
          break;
        case "wanAddress":
          if (member.getValue() instanceof String) {
            obj.setWanAddress((String)member.getValue());
          }
          break;
      }
    }
  }

   static void toJson(Node obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(Node obj, java.util.Map<String, Object> json) {
    if (obj.getAddress() != null) {
      json.put("address", obj.getAddress());
    }
    if (obj.getDatacenter() != null) {
      json.put("datacenter", obj.getDatacenter());
    }
    if (obj.getId() != null) {
      json.put("id", obj.getId());
    }
    if (obj.getLanAddress() != null) {
      json.put("lanAddress", obj.getLanAddress());
    }
    if (obj.getName() != null) {
      json.put("name", obj.getName());
    }
    if (obj.getNodeMeta() != null) {
      JsonObject map = new JsonObject();
      obj.getNodeMeta().forEach((key, value) -> map.put(key, value));
      json.put("nodeMeta", map);
    }
    if (obj.getWanAddress() != null) {
      json.put("wanAddress", obj.getWanAddress());
    }
  }
}
