package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

/**
 * Converter and mapper for {@link io.vertx.ext.consul.TxnServiceOperation}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.TxnServiceOperation} original class using Vert.x codegen.
 */
public class TxnServiceOperationConverter {


  private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
  private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

  public static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, TxnServiceOperation obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "node":
          if (member.getValue() instanceof String) {
            obj.setNode((String)member.getValue());
          }
          break;
        case "serviceOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setServiceOptions(new io.vertx.ext.consul.ServiceOptions((io.vertx.core.json.JsonObject)member.getValue()));
          }
          break;
        case "type":
          if (member.getValue() instanceof String) {
            obj.setType(io.vertx.ext.consul.TxnServiceVerb.valueOf((String)member.getValue()));
          }
          break;
      }
    }
  }

  public static void toJson(TxnServiceOperation obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

  public static void toJson(TxnServiceOperation obj, java.util.Map<String, Object> json) {
    if (obj.getNode() != null) {
      json.put("node", obj.getNode());
    }
    if (obj.getServiceOptions() != null) {
      json.put("serviceOptions", obj.getServiceOptions().toJson());
    }
    if (obj.getType() != null) {
      json.put("type", obj.getType().name());
    }
  }
}
