/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.consul.Coordinate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class CoordinateConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, Coordinate obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "adj": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setAdj(((Number)member.getValue()).floatValue());
                    break;
                }
                case "err": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setErr(((Number)member.getValue()).floatValue());
                    break;
                }
                case "height": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHeight(((Number)member.getValue()).floatValue());
                    break;
                }
                case "node": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setNode((String)member.getValue());
                    break;
                }
                case "vec": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Float> list = new ArrayList<Float>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(Float.valueOf(((Number)item).floatValue()));
                        }
                    });
                    obj.setVec(list);
                }
            }
        }
    }

    static void toJson(Coordinate obj, JsonObject json) {
        CoordinateConverter.toJson(obj, json.getMap());
    }

    static void toJson(Coordinate obj, Map<String, Object> json) {
        json.put("adj", Float.valueOf(obj.getAdj()));
        json.put("err", Float.valueOf(obj.getErr()));
        json.put("height", Float.valueOf(obj.getHeight()));
        if (obj.getNode() != null) {
            json.put("node", obj.getNode());
        }
        if (obj.getVec() != null) {
            JsonArray array = new JsonArray();
            obj.getVec().forEach(item -> array.add(item));
            json.put("vec", array);
        }
    }
}

