/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@DataObject
public class PreparedQueryDefinition {
    private String id;
    private String name;
    private String session;
    private String service;
    private String token;
    private String dnsTtl;
    private int nearestN;
    private List<String> dcs;
    private List<String> tags;
    private boolean passing;
    private Map<String, String> meta;
    private String templateType;
    private String templateRegexp;

    public PreparedQueryDefinition() {
    }

    public PreparedQueryDefinition(JsonObject json) {
        JsonObject templateJson;
        JsonObject metaJson;
        this.id = json.getString("ID");
        this.name = json.getString("Name");
        this.session = json.getString("Session");
        this.token = json.getString("Token");
        this.service = json.getJsonObject("Service").getString("Service");
        this.nearestN = json.getJsonObject("Service").getJsonObject("Failover").getInteger("NearestN");
        JsonArray dcsJson = json.getJsonObject("Service").getJsonObject("Failover").getJsonArray("Datacenters");
        if (dcsJson != null) {
            this.dcs = dcsJson.stream().map(o -> (String)o).collect(Collectors.toList());
        }
        this.passing = json.getJsonObject("Service").getBoolean("OnlyPassing");
        JsonArray tagsJson = json.getJsonObject("Service").getJsonArray("Tags");
        if (tagsJson != null) {
            this.tags = tagsJson.stream().map(o -> (String)o).collect(Collectors.toList());
        }
        if ((metaJson = json.getJsonObject("Service").getJsonObject("NodeMeta")) != null) {
            this.meta = metaJson.stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        }
        if ((templateJson = json.getJsonObject("Template")) != null) {
            this.templateType = templateJson.getString("Type");
            this.templateRegexp = templateJson.getString("Regexp");
        }
        this.dnsTtl = json.getJsonObject("DNS").getString("TTL");
    }

    public JsonObject toJson() {
        return new JsonObject().put("ID", (Object)this.id).put("Name", (Object)this.name).put("Session", (Object)this.session).put("Token", (Object)this.token).put("Template", (Object)new JsonObject().put("Type", (Object)this.templateType).put("Regexp", (Object)this.templateRegexp)).put("Service", (Object)new JsonObject().put("Service", (Object)this.service).put("Failover", (Object)new JsonObject().put("NearestN", (Object)this.nearestN).put("Datacenters", this.dcs)).put("OnlyPassing", (Object)this.passing).put("Tags", this.tags).put("NodeMeta", this.meta)).put("DNS", (Object)new JsonObject().put("TTL", (Object)this.dnsTtl));
    }

    public String getId() {
        return this.id;
    }

    public PreparedQueryDefinition setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PreparedQueryDefinition setName(String name) {
        this.name = name;
        return this;
    }

    public String getSession() {
        return this.session;
    }

    public PreparedQueryDefinition setSession(String session) {
        this.session = session;
        return this;
    }

    public String getService() {
        return this.service;
    }

    public PreparedQueryDefinition setService(String service) {
        this.service = service;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public PreparedQueryDefinition setToken(String token) {
        this.token = token;
        return this;
    }

    public String getDnsTtl() {
        return this.dnsTtl;
    }

    public PreparedQueryDefinition setDnsTtl(String dnsTtl) {
        this.dnsTtl = dnsTtl;
        return this;
    }

    public int getNearestN() {
        return this.nearestN;
    }

    public PreparedQueryDefinition setNearestN(int nearestN) {
        this.nearestN = nearestN;
        return this;
    }

    public List<String> getDcs() {
        return this.dcs;
    }

    public PreparedQueryDefinition setDcs(List<String> dcs) {
        this.dcs = dcs;
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public PreparedQueryDefinition setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public boolean getPassing() {
        return this.passing;
    }

    public PreparedQueryDefinition setPassing(boolean passing) {
        this.passing = passing;
        return this;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public PreparedQueryDefinition setMeta(Map<String, String> meta) {
        this.meta = meta;
        return this;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public PreparedQueryDefinition setTemplateType(String templateType) {
        this.templateType = templateType;
        return this;
    }

    public String getTemplateRegexp() {
        return this.templateRegexp;
    }

    public PreparedQueryDefinition setTemplateRegexp(String templateRegexp) {
        this.templateRegexp = templateRegexp;
        return this;
    }
}

