/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntry;
import java.util.ArrayList;
import java.util.Map;

public class ServiceEntryConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, ServiceEntry obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "node": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setNode(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "service": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setService(new Service((JsonObject)member.getValue()));
                    break;
                }
                case "checks": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Check> list = new ArrayList<Check>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Check((JsonObject)item));
                        }
                    });
                    obj.setChecks(list);
                }
            }
        }
    }

    static void toJson(ServiceEntry obj, JsonObject json) {
        ServiceEntryConverter.toJson(obj, json.getMap());
    }

    static void toJson(ServiceEntry obj, Map<String, Object> json) {
        if (obj.getNode() != null) {
            json.put("node", obj.getNode().toJson());
        }
        if (obj.getService() != null) {
            json.put("service", obj.getService().toJson());
        }
        if (obj.getChecks() != null) {
            JsonArray array = new JsonArray();
            obj.getChecks().forEach(item -> array.add((Object)item.toJson()));
            json.put("checks", array);
        }
    }
}

